/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands.transformers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public class JobTypeListTransformer
implements Transformer<String, List<JobType>> {
    public List<JobType> transform(String rawValue, TransformContext context, Environment environment) {
        String[] list;
        ArrayList<JobType> jobTypeList = new ArrayList<JobType>();
        for (String job_str : list = rawValue.split(",")) {
            try {
                JobType job_type = JobType.valueOf(job_str.toUpperCase());
                jobTypeList.add(job_type);
            }
            catch (IllegalArgumentException ex) {
                context.addError(RcvMessages.format("INVALID_OPTION_VALUE", job_str, "job_type", Arrays.toString((Object[])JobType.values())));
            }
        }
        return jobTypeList;
    }
}

