/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import oracle.dbtools.extension.rcv.commands.completer.ProtectionPolicyCompleter;
import oracle.dbtools.extension.rcv.commands.completer.RCVCompartmentCompleter;
import oracle.dbtools.extension.rcv.commands.completer.RecoverySubnetsListCompleter;
import oracle.dbtools.extension.rcv.commands.transformers.JobTypeListTransformer;
import oracle.dbtools.extension.rcv.commands.transformers.RCVCompartmentTransformer;
import oracle.dbtools.extension.rcv.commands.transformers.RecoverySubnetList;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.net.commands.completers.CompartmentCompleter;
import oracle.dbtools.net.commands.completers.CompartmentPathMapper;
import oracle.dbtools.raptor.newscriptrunner.util.completer.FileCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.ChainedTransformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.IntRange;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.PrimitiveTransformers;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.StringEnum;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.StringList;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.datetime.SimpleDateTimeTransformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.file.DirectoryExists;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.file.FileExists;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.number.PositiveIntegerTransformer;

public class RCVOptions {
    public static final Option<String> ALIAS_O = ((OptionBuilder)Factory.option((Id)Options.ALIAS).dataType(String.class)).build();
    public static final Option<String> AUTO_DISCOVER_O = Factory.option((Id)Options.AUTO_DISCOVER).flag().build();
    public static final Option<Double> CHANGE_RATE_O = ((OptionBuilder)Factory.option((Id)Options.CHANGE_RATE).dataType(Double.class)).build();
    public static final Option<String> CHECK_GROUP_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.GROUP).dataType(String.class)).transformer(new Transformer[]{new StringEnum(new String[]{"ONBOARDING_PRECHECKS", "REALTIME_REDO_PRECHECKS", "HEALTH", "ALL"})})).build();
    private static final CompartmentPathMapper compartmentPathMapper = new CompartmentPathMapper();
    private static final CompartmentCompleter compartmentCompleter = RCVCompartmentCompleter.ofDisplayNames(compartmentPathMapper);
    public static final Option<String> COMPARTMENT_ID_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.COMPARTMENT_ID).completer(new SemanticCompleter[]{compartmentCompleter})).transformer(new Transformer[]{new RCVCompartmentTransformer(compartmentPathMapper, compartmentCompleter)})).dataType(String.class)).build();
    public static final Option<Double> COMPRESSION_RATIO = ((OptionBuilder)Factory.option((Id)Options.COMPRESSION_RATIO).dataType(Double.class)).build();
    public static final Option<String> CONFIG_JSON_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.CONFIG).dataType(String.class)).transformer(new Transformer[]{new FileExists()})).completer(new SemanticCompleter[]{new FileCompleter()})).build();
    public static final Option<String> CONFIG_NAME_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.CONFIG_NAME).dataType(String.class)).required()).build();
    public static final Option<String> CONFIG_VALUE_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.CONFIG_VALUE).dataType(String.class)).required()).build();
    public static final Option<String> DATABASE_ID_O = ((OptionBuilder)Factory.option((Id)Options.DATABASE_ID).dataType(String.class)).build();
    public static final Option<String> DATABASE_SIZE_O = ((OptionBuilder)Factory.option((Id)Options.DATABASE_SIZE).dataType(Integer.class)).build();
    public static final Option<String> DB_UNIQUE_NAME_O = ((OptionBuilder)Factory.option((Id)Options.DB_UNIQUE_NAME).dataType(String.class)).build();
    public static final Option<String> DELETE_AFTER_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.DELETE_AFTER).dataType(String.class)).transformer(new Transformer[]{new StringEnum(new String[]{"72_hours", "retention_period"})})).defaultValue((Object)"retention_period")).build();
    public static final Option<String> ENDPOINT_O = ((OptionBuilder)Factory.option((Id)Options.ENDPOINT).dataType(String.class)).build();
    public static final Option<String> FORCE_O = Factory.option((Id)Options.FORCE).flag().build();
    public static final Option<String> FULL_O = Factory.option((Id)Options.FULL).flag().helpId().build();
    public static final Option<String> GENERATE_CONFIG_ONLY_O = Factory.option((Id)Options.GENERATE_CONFIG_ONLY).flag().build();
    public static final Option<String> GROUP_FLAG_O = Factory.option((Id)Options.GROUP).flag().build();
    public static final Option<String> INTERVAL_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.INTERVAL).dataType(Integer.class)).transformer(new Transformer[]{new PositiveIntegerTransformer()})).build();
    public static final Option<String> JOB_TYPE_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.JOB_TYPE).dataType(String.class)).defaultValue((Object)JobType.BACKUP.name().toUpperCase())).transformer(new Transformer[]{new StringEnum((String[])Arrays.stream(JobType.values()).map(Enum::name).toArray(String[]::new))})).build();
    public static final Option<Boolean> LEVEL_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.LEVEL).dataType(Integer.class)).transformer(new Transformer[]{new ChainedTransformer(new Transformer[]{new StringEnum(new String[]{"0", "1"}), PrimitiveTransformers.get(Integer.class)})})).build();
    public static final Option<List<String>> LOCAL_O = Factory.option((Id)Options.LOCAL).flag().helpId().build();
    public static final Option<String> LOG_LEVEL_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.LOG_LEVEL).dataType(String.class)).transformer(new Transformer[]{new StringEnum(new String[]{"INFO", "TRACE"})})).required()).build();
    public static final Option<String> METHOD_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.METHOD).dataType(String.class)).transformer(new Transformer[]{new StringEnum(new String[]{"RESOURCE_PRINCIPAL", "API_KEY"})})).defaultValue((Object)"API_KEY")).build();
    public static final Option<String> NAME_O = ((OptionBuilder)Factory.option((Id)Options.NAME).dataType(String.class)).build();
    public static final Option<String> NETWORK_SECURITY_GROUPS_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.NETWORK_SECURITY_GROUPS).abbrevs(new String[]{"nsgs"}).transformer(new Transformer[]{new StringList()})).dataType(List.class)).build();
    public static final Option<String> OCI_CONFIG_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.OCI_CONFIG).transformer(new Transformer[]{new FileExists()})).completer(new SemanticCompleter[]{new FileCompleter()})).dataType(String.class)).build();
    public static final Option<String> ORACLE_SID_O = ((OptionBuilder)Factory.option((Id)Options.ORACLE_SID).dataType(String.class)).build();
    public static final Option<Boolean> PASSWORD_O = Factory.option((Id)Options.PASSWORD).flag().build();
    public static final Option<String> POLICY_LOCKED_DATETIME_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.POLICY_LOCKED_DATETIME).dataType(Date.class)).transformer(new Transformer[]{new SimpleDateTimeTransformer()})).build();
    public static final Option<String> PROFILE_NAME_O = ((OptionBuilder)Factory.option((Id)Options.PROFILE_NAME).dataType(String.class)).build();
    public static final Option<String> PROTECTION_POLICY_ID_O = ((OptionBuilder)Factory.option((Id)Options.PROTECTION_POLICY_ID).dataType(String.class)).build();
    public static final Option<String> PROTECTION_POLICY_NAME_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.PROTECTION_POLICY_NAME).completer(new SemanticCompleter[]{ProtectionPolicyCompleter.ofNames()})).dataType(String.class)).build();
    public static final Option<String> REALTIME_REDO_O = Factory.option((Id)Options.REALTIME_REDO).flag().build();
    public static final Option<List<String>> RECOVERY_SERVICE_SUBNETS_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.RECOVERY_SERVICE_SUBNETS).completer(new SemanticCompleter[]{new RecoverySubnetsListCompleter()})).transformer(new Transformer[]{new RecoverySubnetList()})).dataType(List.class)).required()).build();
    public static final Option<List<String>> RECOVERY_SERVICE_SUBNETS_OPTIONAL_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.RECOVERY_SERVICE_SUBNETS).transformer(new Transformer[]{new StringList()})).dataType(List.class)).build();
    public static final Option<String> REMOVE_JOB_TYPE_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.JOB_TYPE).dataType(List.class)).transformer(new Transformer[]{new JobTypeListTransformer()})).required()).build();
    public static final Option<Integer> RETENTION_PERIOD_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.RETENTION_PERIOD).dataType(Integer.class)).transformer(new Transformer[]{new PositiveIntegerTransformer()})).build();
    public static final Option<Integer> RETENTION_PERIOD_REQUIRED_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.RETENTION_PERIOD).dataType(Integer.class)).required()).transformer(new Transformer[]{new PositiveIntegerTransformer()})).build();
    public static final Option<String> SBT_LIBRARY_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.SBT_LIBRARY).transformer(new Transformer[]{new FileExists()})).completer(new SemanticCompleter[]{new FileCompleter()})).dataType(String.class)).build();
    public static final Option<String> SCHEDULED_O = Factory.option((Id)Options.SCHEDULED).flag().helpId().build();
    public static final Option<String> START_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.START).dataType(Integer.class)).transformer(new Transformer[]{new IntRange(0, 59)})).helpId().build();
    public static final Option<String> SUBNET_ID_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.SUBNET_ID).dataType(String.class)).required()).build();
    public static final Option<String> SUBNETS_O = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.SUBNETS).transformer(new Transformer[]{new StringList()})).dataType(List.class)).build();
    public static final Option<Boolean> VALIDATE_O = Factory.option((Id)Options.VALIDATE).flag().build();
    public static final Option<String> VCN_ID_O = ((OptionBuilder)Factory.option((Id)Options.VCN_ID).dataType(String.class)).build();
    public static final Option<String> WALLET_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.WALLET).transformer(new Transformer[]{new FileExists()})).completer(new SemanticCompleter[]{new FileCompleter()})).dataType(String.class)).build();

    public static Option<String> getCompartmentIdOption(String helpId, boolean required) {
        OptionBuilder builder = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.COMPARTMENT_ID).completer(new SemanticCompleter[]{compartmentCompleter})).transformer(new Transformer[]{new RCVCompartmentTransformer(compartmentPathMapper, compartmentCompleter)})).dataType(String.class)).helpId(helpId);
        if (required) {
            builder.required();
        }
        return builder.build();
    }

    public static Option<String> getNameOption(String helpId, boolean required) {
        OptionBuilder builder = ((OptionBuilder)Factory.option((Id)Options.NAME).dataType(String.class)).helpId(helpId);
        if (required) {
            builder.required();
        }
        return builder.build();
    }

    public static Option<String> buildRequiredOption(Id optiondID, String helpId, SemanticCompleter ... completers) {
        return ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)optiondID).completer(completers)).dataType(String.class)).helpId(helpId).required()).build();
    }

    public static Option<String> buildOption(Id optionID, String helpId, boolean required) {
        OptionBuilder builder = ((OptionBuilder)Factory.option((Id)optionID).dataType(String.class)).helpId(helpId);
        if (required) {
            builder.required();
        }
        return builder.build();
    }

    public static Option<String> buildOption(Id optiondID, SemanticCompleter ... completers) {
        return ((OptionBuilder)((OptionBuilder)Factory.option((Id)optiondID).completer(completers)).dataType(String.class)).build();
    }

    public static Option<String> getOracleHomeOption(String helpId) {
        return ((OptionBuilder)((OptionBuilder)Factory.option((Id)Options.ORACLE_HOME).transformer(new Transformer[]{new DirectoryExists()})).dataType(String.class)).helpId(helpId).build();
    }

    public static enum Options implements Id
    {
        ALIAS,
        AUTO_DISCOVER,
        CHANGE_RATE,
        COMPARTMENT_ID,
        COMPRESSION_RATIO,
        CONFIG,
        CONFIG_NAME,
        CONFIG_VALUE,
        DATABASE_ID,
        DATABASE_SIZE,
        DB_UNIQUE_NAME,
        ENDPOINT,
        DELETE_AFTER,
        FORCE,
        FULL,
        GENERATE_CONFIG_ONLY,
        GROUP,
        ID,
        INTERVAL,
        JOB_TYPE,
        LEVEL,
        LOCAL,
        LOG_LEVEL,
        METHOD,
        NAME,
        NETWORK_SECURITY_GROUPS,
        OCI_CONFIG,
        ORACLE_HOME,
        ORACLE_SID,
        PASSWORD,
        POLICY_LOCKED_DATETIME,
        PROFILE_NAME,
        PROTECTION_POLICY_ID,
        PROTECTION_POLICY_NAME,
        REALTIME_REDO,
        RECOVERY_SERVICE_SUBNETS,
        RETENTION_PERIOD,
        SBT_LIBRARY,
        SCHEDULED,
        SOURCE_WALLET,
        START,
        SUBNETS,
        SUBNET_ID,
        TYPE,
        VALIDATE,
        VCN_ID,
        WALLET;

    }
}

