/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import oracle.dbtools.extension.rcv.commands.RCVGrammar;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;

public class RCVCommand {
    private static Parser parser;
    private SubCommand subCommand;
    private Set<RCVOptions.Options> flags;
    private HashMap<RCVOptions.Options, String> options;

    public RCVCommand(SubCommand subCommand) {
        this.subCommand = subCommand;
        this.flags = new HashSet<RCVOptions.Options>();
        this.options = new HashMap();
    }

    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    public RCVCommand addOption(RCVOptions.Options name, String value) {
        this.options.put(name, value);
        return this;
    }

    public RCVCommand addFlag(RCVOptions.Options flag) {
        this.flags.add(flag);
        return this;
    }

    public String toString() {
        StringBuilder rcvCommand = new StringBuilder(String.format("%s %s", new Object[]{RCVGrammar.Base.RCV, this.subCommand.toString()}));
        for (RCVOptions.Options optionName : this.options.keySet()) {
            if (this.options.get((Object)optionName) == null) continue;
            rcvCommand.append(String.format(" -%s %s", new Object[]{optionName, this.options.get((Object)optionName)}));
        }
        for (RCVOptions.Options optionName : this.flags) {
            rcvCommand.append(" -");
            rcvCommand.append((Object)optionName);
        }
        return rcvCommand.toString();
    }

    public ParsedCommand build(ScriptRunnerContext ctx) {
        Optional command;
        String rcvCommand = this.toString();
        if (parser == null) {
            parser = new Parser(RCVGrammar.createType(), ctx.getEnvironment());
        }
        if ((command = parser.parse(rcvCommand, arg_0 -> ((ScriptRunnerContext)ctx).writeln(arg_0))).isEmpty()) {
            throw new IllegalArgumentException("Invalid rcv command " + rcvCommand);
        }
        return (ParsedCommand)command.get();
    }

    public static enum SubCommand implements Id
    {
        ADD_DATABASE(String.valueOf((Object)((Object)RCVVerbs.ADD)) + " " + String.valueOf((Object)((Object)RCVObjects.DATABASE))),
        ADD_PROTECTION_POLICY(String.valueOf((Object)((Object)RCVVerbs.ADD)) + " " + String.valueOf((Object)((Object)RCVObjects.PROTECTION_POLICY))),
        ADD_REALTIME_REDO(String.valueOf((Object)((Object)RCVVerbs.ADD)) + " " + String.valueOf((Object)((Object)RCVObjects.REALTIME_REDO))),
        ADD_RECOVERY_SERVICE_SUBNET(String.valueOf((Object)((Object)RCVVerbs.ADD)) + " " + String.valueOf((Object)((Object)RCVObjects.RECOVERY_SERVICE_SUBNET))),
        ADD_SCHEDULE(String.valueOf((Object)((Object)RCVVerbs.ADD)) + " " + String.valueOf((Object)((Object)RCVObjects.SCHEDULE))),
        ADD_SYSBACKUP_USER(String.valueOf((Object)((Object)RCVVerbs.ADD)) + " " + String.valueOf((Object)((Object)RCVObjects.SYSBACKUP_USER))),
        BACKUP_DATABASE(String.valueOf((Object)((Object)RCVVerbs.BACKUP)) + " " + String.valueOf((Object)((Object)RCVObjects.DATABASE))),
        CONFIGURE_AUTHENTICATION(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.AUTHENTICATION))),
        CONFIGURE_LOG(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.LOG))),
        CONFIGURE_DATABASE(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.DATABASE))),
        CONFIGURE_PROTECTION_POLICY(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.PROTECTION_POLICY))),
        CONFIGURE_RECOVERY_SERVICE_SUBNET(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.RECOVERY_SERVICE_SUBNET))),
        CONFIGURE_RMAN(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.RMAN))),
        CONFIGURE_RMAN_ENV(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.RMAN_ENV))),
        CONFIGURE_SCHEDULE(String.valueOf((Object)((Object)RCVVerbs.CONFIGURE)) + " " + String.valueOf((Object)((Object)RCVObjects.SCHEDULE))),
        FETCH_TASK(String.valueOf((Object)((Object)RCVVerbs.FETCH)) + " " + String.valueOf((Object)((Object)RCVObjects.TASK))),
        FETCH_CONFIG(String.valueOf((Object)((Object)RCVVerbs.FETCH)) + " " + String.valueOf((Object)((Object)RCVObjects.ZRCV_CONFIG))),
        IMPORT_DATABASE(String.valueOf((Object)((Object)RCVVerbs.IMPORT)) + " " + String.valueOf((Object)((Object)RCVObjects.DATABASE))),
        REMOVE_DATABASE(String.valueOf((Object)((Object)RCVVerbs.REMOVE)) + " " + String.valueOf((Object)((Object)RCVObjects.DATABASE))),
        REMOVE_LOG(String.valueOf((Object)((Object)RCVVerbs.REMOVE)) + " " + String.valueOf((Object)((Object)RCVObjects.LOG))),
        REMOVE_PROTECTION_POLICY(String.valueOf((Object)((Object)RCVVerbs.REMOVE)) + " " + String.valueOf((Object)((Object)RCVObjects.PROTECTION_POLICY))),
        REMOVE_REALTIME_REDO(String.valueOf((Object)((Object)RCVVerbs.REMOVE)) + " " + String.valueOf((Object)((Object)RCVObjects.REALTIME_REDO))),
        REMOVE_RECOVERY_SERVICE_SUBNET(String.valueOf((Object)((Object)RCVVerbs.REMOVE)) + " " + String.valueOf((Object)((Object)RCVObjects.RECOVERY_SERVICE_SUBNET))),
        REMOVE_SCHEDULE(String.valueOf((Object)((Object)RCVVerbs.REMOVE)) + " " + String.valueOf((Object)((Object)RCVObjects.SCHEDULE))),
        RUN_CHECKS(String.valueOf((Object)((Object)RCVVerbs.RUN)) + " " + String.valueOf((Object)((Object)RCVObjects.CHECKS))),
        SHOW_AUTHENTICATION(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.AUTHENTICATION))),
        SHOW_CHECKS(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.CHECKS))),
        SHOW_DATABASE(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.DATABASE))),
        SHOW_PROTECTION_POLICY(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.PROTECTION_POLICY))),
        SHOW_RECOVERY_SERVICE_SUBNET(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.RECOVERY_SERVICE_SUBNET))),
        SHOW_RESTORE_RANGE(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.RESTORE_RANGE))),
        SHOW_RMAN(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.RMAN))),
        SHOW_SCHEDULE(String.valueOf((Object)((Object)RCVVerbs.SHOW)) + " " + String.valueOf((Object)((Object)RCVObjects.SCHEDULE)));

        private final String[] strings;

        private SubCommand(String ... strings) {
            this.strings = strings;
        }

        public String toString() {
            return this.strings[0];
        }

        public static SubCommand fromString(String string) {
            for (SubCommand s : SubCommand.values()) {
                for (String name : s.strings) {
                    if (!name.equalsIgnoreCase(string)) continue;
                    return s;
                }
            }
            throw new IllegalArgumentException("Invalid rcv command: " + string);
        }
    }
}

