/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.rtrt;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.workflows.check.rtrt.CheckMessages;

public class RedoTransportUserCheck
extends Check {
    public static final String NAME = "Redo Transport User";
    public static final String ID = "redo_transport_user";
    private Connection conn;

    public RedoTransportUserCheck(Connection conn) {
        super(conn, NAME, ID);
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        String currentUser = DatabaseUtils.getRedoTransportUser(this.conn);
        Database database = RCVCommandBase.getDatabase(this.conn);
        if (!(currentUser == null || currentUser.equals("null") || currentUser.trim().isEmpty() || currentUser.equals(database.getFleetAgentContext().getProtectedDatabaseCache().getVpcUserName()))) {
            return new CheckResult(CheckResult.Status.FAIL, CheckMessages.get("INVALID_REDO_TRANSPORT_USER"), CheckMessages.get("INVALID_REDO_TRANSPORT_USER_ACTION_PLAN"));
        }
        return new CheckResult(CheckResult.Status.PASS, null);
    }
}

