/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.onboarding;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;

public class BackupTapeIOSlaves
extends Check {
    public static final String ID = "backup_tape_io_slaves";
    private Connection conn;

    public BackupTapeIOSlaves(Connection conn) {
        super(conn, "Backup Tape IO Slaves Check", ID);
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        String mode = DatabaseUtils.getParameter(this.conn, ID);
        if (mode.equalsIgnoreCase("FALSE")) {
            return new CheckResult(CheckResult.Status.PASS, "Backup Tape IO Slaves is set to FALSE.");
        }
        return new CheckResult(CheckResult.Status.FAIL, "Backup Tape IO Slaves is not set to FALSE.", "Please set backup_tape_io_slaves to FALSE.");
    }
}

