/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.io.IOException;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.util.Pair;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public final class Tunnel {
    private final HostConnection mOwningConnection;
    private final TunnelDescriptor mDesc;
    private SshdSocketAddress tunnelAddress;

    private static AddressPair getForwarding(TunnelDescriptor desc) {
        SshdSocketAddress remote;
        SshdSocketAddress local;
        int originPort = desc.getPort();
        String hostname = desc.getHostname();
        int hostport = desc.getHostport();
        switch (desc.getType()) {
            case LOCAL: {
                local = new SshdSocketAddress(originPort);
                remote = new SshdSocketAddress(hostname, hostport);
                break;
            }
            case REMOTE: {
                local = new SshdSocketAddress(hostname, hostport);
                remote = new SshdSocketAddress(originPort);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Tunnel type: " + desc.toString());
            }
        }
        return new AddressPair(local, remote);
    }

    Tunnel(HostConnection conn, TunnelDescriptor desc) {
        this.mOwningConnection = conn;
        this.mDesc = desc;
    }

    public int getPort() {
        return this.tunnelAddress != null ? this.tunnelAddress.getPort() : -1;
    }

    public HostConnection getConnection() {
        return this.mOwningConnection;
    }

    public TunnelDescriptor getDescriptor() {
        return this.mDesc;
    }

    synchronized int connect() throws IOException {
        ClientSession session = this.mOwningConnection.getSession();
        AddressPair addresses = Tunnel.getForwarding(this.mDesc);
        switch (this.mDesc.getType()) {
            case LOCAL: {
                this.tunnelAddress = session.startLocalPortForwarding(addresses.local(), addresses.remote());
                break;
            }
            case REMOTE: {
                this.tunnelAddress = session.startRemotePortForwarding(addresses.local(), addresses.remote());
                break;
            }
            default: {
                this.tunnelAddress = null;
            }
        }
        return this.tunnelAddress != null ? this.tunnelAddress.getPort() : -1;
    }

    synchronized void disconnect() throws IOException {
        ClientSession session = this.mOwningConnection.getSession();
        if (this.tunnelAddress != null) {
            switch (this.mDesc.getType()) {
                case LOCAL: {
                    session.stopLocalPortForwarding(this.tunnelAddress);
                    break;
                }
                case REMOTE: {
                    session.stopRemotePortForwarding(this.tunnelAddress);
                }
            }
            this.tunnelAddress = null;
        }
    }

    private static final class AddressPair
    extends Pair<SshdSocketAddress, SshdSocketAddress> {
        AddressPair(SshdSocketAddress local, SshdSocketAddress remote) {
            super((Object)local, (Object)remote);
        }

        public SshdSocketAddress local() {
            return (SshdSocketAddress)this.first();
        }

        public SshdSocketAddress remote() {
            return (SshdSocketAddress)this.second();
        }
    }
}

