/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.nio.file.Path;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.DefaultKnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.RejectAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;

public interface KnownHosts {
    public static final KnownHosts DEFAULT_STRICT = new KnownHosts(){

        @Override
        public ServerKeyVerifier getServerKeyVerifier() {
            return Holder.DEFAULT_STRICT_VERIFIER;
        }
    };
    public static final KnownHosts DEFAULT_LENIENT = new KnownHosts(){

        @Override
        public ServerKeyVerifier getServerKeyVerifier() {
            return Holder.DEFAULT_LENIENT_VERIFIER;
        }
    };
    public static final KnownHosts NONE = new KnownHosts(){

        @Override
        public ServerKeyVerifier getServerKeyVerifier() {
            return Holder.NO_VERIFIER;
        }
    };

    public ServerKeyVerifier getServerKeyVerifier();

    public static KnownHosts knownHostsFor(Path file, boolean strict) {
        return () -> new KnownHostsServerKeyVerifier((ServerKeyVerifier)(strict ? RejectAllServerKeyVerifier.INSTANCE : AcceptAllServerKeyVerifier.INSTANCE), file);
    }

    public static class Holder {
        private static ServerKeyVerifier DEFAULT_STRICT_VERIFIER = new DefaultKnownHostsServerKeyVerifier((ServerKeyVerifier)RejectAllServerKeyVerifier.INSTANCE);
        private static ServerKeyVerifier DEFAULT_LENIENT_VERIFIER = new DefaultKnownHostsServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
        private static ServerKeyVerifier NO_VERIFIER = AcceptAllServerKeyVerifier.INSTANCE;
    }
}

