/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.net.URL;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.core.Descriptor;

public final class HostDescriptor
extends Descriptor {
    private final String hostname;
    private final int port;
    private final String username;
    private final URL keyfile;
    private Properties props;

    private HostDescriptor(String name, String hostname, int port, URL keyfile, String username) {
        super(name);
        this.hostname = hostname;
        this.username = username;
        this.port = port;
        this.keyfile = keyfile;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HostDescriptor) {
            return this.equalsImpl((HostDescriptor)obj);
        }
        return false;
    }

    protected boolean equalsImpl(HostDescriptor other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.hostname, (Object)other.hostname) && this.port == other.port && ModelUtil.areEqual((Object)this.username, (Object)other.username) && ModelUtil.areEqual((Object)this.keyfile, (Object)other.keyfile) && ModelUtil.areEqual((Object)this.props, (Object)other.props);
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getProperty(String key) {
        return this.props != null ? this.props.getProperty(key) : null;
    }

    public Set<String> getPropertyNames() {
        return this.props != null ? this.props.stringPropertyNames() : Collections.emptySet();
    }

    public String getUsername() {
        return this.username;
    }

    public URL getKeyfile() {
        return this.keyfile;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    private void setProperty(String key, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(key, value);
    }

    public static final class Builder {
        private String name;
        private String hostname;
        private String username;
        private int port = 22;
        private URL keyfile;
        private Properties props = new Properties();

        public Builder(String name) {
            this.name = name;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder keyfile(URL keyfile) {
            this.keyfile = keyfile;
            return this;
        }

        public Builder setProperty(String key, String value) {
            this.props.setProperty(key, value);
            return this;
        }

        public HostDescriptor getDescriptor() {
            if (this.hostname == null) {
                throw new IllegalStateException("hostname must not be null");
            }
            if (this.username == null) {
                throw new IllegalStateException("username must not be null");
            }
            HostDescriptor desc = new HostDescriptor(this.name, this.hostname, this.port, this.keyfile, this.username);
            if (this.props.size() > 0) {
                for (String key : this.props.stringPropertyNames()) {
                    desc.setProperty(key, this.props.getProperty(key));
                }
            }
            return desc;
        }
    }
}

