/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.completers;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.util.Logger;

public abstract class BaseOCICompleter<C extends OCIClient, B extends OCIClient.Builder<B, C>, T>
implements SemanticCompleter {
    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        try {
            String profileName = ctx.getStringProperty("oci.profile.name", null);
            OCIProfile profile = this.getProfile(null, profileName);
            if (profile != null) {
                B builder = this.getClientBuilder(profile, transformedOptionsMap);
                String region = ctx.getStringProperty("oci.region.name", null);
                if (region != null) {
                    builder.region(region);
                }
                OCIClient client = (OCIClient)builder.build();
                List<T> items = this.listItems(client, profile.getTenantId(), transformedOptionsMap);
                return items.stream().map(item -> this.mapItem(item, prefix)).map(res -> new CompletionItem(res, CompletionItem.Type.KEYWORD)).collect(Collectors.toUnmodifiableList());
            }
        }
        catch (IOException | RuntimeException e) {
            Logger.warn(this.getClass(), (String)e.getMessage(), (Throwable)e);
        }
        return List.of();
    }

    protected abstract B getClientBuilder(OCIProfile var1, Map<String, Object> var2);

    protected abstract List<T> listItems(C var1, String var2, Map<String, Object> var3);

    protected abstract String mapItem(T var1, String var2);

    protected OCIProfile getProfile(String configPath, String profileName) throws IOException {
        OCIProfiles.Builder builder = OCIProfiles.builder();
        if (configPath != null) {
            builder.configPath(configPath);
        }
        OCIProfiles profiles = builder.build();
        return profiles.getProfile(profileName);
    }
}

