/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.net.commands.CSCommon;
import oracle.dbtools.net.commands.CommandMessages;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleDbDirectoryLocation;

public class CloudStorageCommand
extends CommandListener
implements IHelp,
IShowCommand {
    private static final String CLEAR = "clear";
    private static final String CS = "cs";
    private static final String CLOUDSTORAGE = "cloudstorage";
    private static final String CLOUD_STORAGE = "cloud_storage";
    private static final String DELETE = "delete";
    private static final String GET = "get";
    private static final String HELP = "help";
    private static final String LISTB = "listb";
    private static final String LISTBUCKETS = "listbuckets";
    private static final String LISTC = "listc";
    private static final String LISTCOMPARTMENTS = "listcompartments";
    private static final String LISTO = "listo";
    private static final String LISTOBJECTS = "listobjects";
    private static final String PEEK = "peek";
    private static final String PUT = "put";
    private static final String SHOW = "show";
    public static final String CREDENTIAL = "credential";
    public static final String PASSWORD = "password";
    public static final String CLOUD_STR = "cloud_str";
    public static final String CLOUD_URL = "cloud_url";
    public static final String DBDIR = "dbdir";
    public static final String DBDIRECTORY = "dbdirectory";
    public static final String URL = "url";
    public static final String URI = "uri";
    public static final String USER = "user";
    public static final String COMPARTMENT = "compartment";
    private static final String POS = "pos";
    private static final String POSITION = "position";
    private static final String SIZE = "size";
    private static final String DQUOTE = "\"";
    private static final String SQUOTE = "'";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private Location _location;
    private Connection _conn;
    private Map<String, Object> _props = new HashMap<String, Object>();
    private String _sPos;
    private String _sSize;

    public String getCommand() {
        return "CLOUDSTORAGE";
    }

    public String getHelp() {
        return CommandMessages.getString("CS_CMD_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    public String getDescription() {
        return CommandMessages.getString("CS_DESC");
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block121: {
            this._conn = conn;
            String cmdTrimmed = cmd.getLoweredTrimmedNoWhitespaceSQL();
            if (!cmdTrimmed.startsWith(CS) && !cmdTrimmed.startsWith(CLOUDSTORAGE) && !cmdTrimmed.startsWith(CLOUD_STORAGE)) break block121;
            String[] parts = cmd.getSQLOrig().split(SPACE);
            if (parts.length == 2 && parts[1].equalsIgnoreCase(CLEAR)) {
                ctx.write(CommandMessages.getString("CSCLEARED") + NL);
                ctx.removeProperty("cloud.storage");
                return true;
            }
            if (parts.length < 2 || parts.length == 2 && parts[1].equalsIgnoreCase(HELP)) {
                ctx.write(this.getHelp());
                return true;
            }
            this._props = (Map)ctx.getProperty("cloud.storage");
            if (this._props == null) {
                this._props = new HashMap<String, Object>();
                ctx.putProperty("cloud.storage", this._props);
            } else {
                this._props.remove("qualifier");
            }
            this._location = null;
            this._props.remove("qualifier");
            String[] bits = cmd.getSql().split("\\s+");
            int skip = 0;
            bits = this.nextBits(bits, skip + 1);
            String option = "";
            String listType = "";
            while (bits != null && bits.length > 0) {
                option = bits[skip];
                String cred = "";
                OracleDbDirectoryLocation dirLocation = null;
                String qualifier = null;
                CloudStorageUrl csUrl = null;
                this._sPos = null;
                this._sSize = null;
                try {
                    CloudStorageUrl cloudUrl;
                    switch (bits[skip].toLowerCase()) {
                        case "dbc": 
                        case "dbms_cloud": {
                            cred = (String)this._props.get("dbms.cloud.credential");
                            if (bits.length < skip + 2) {
                                if (cred == null) {
                                    this.writeFormatMissing(ctx, bits[skip]);
                                    return true;
                                }
                                bits = this.nextBits(bits, skip + 1);
                                CSCommon.setTransferAndWarn(ctx, "transfer.dbms_cloud", false);
                            } else {
                                cred = CSCommon.getCredential(bits[skip + 1]);
                                if (CSCommon.existsCredential(ctx, conn, cred)) {
                                    CSCommon.setCredentialAndWarn(ctx, cred, false);
                                    bits = this.nextBits(bits, skip + 2);
                                } else {
                                    ctx.write(CommandMessages.format("DBC_CRED_INVALID", cred) + NL);
                                    return true;
                                }
                            }
                            this.handleShow(ctx, null);
                            return true;
                        }
                        case "delete": {
                            qualifier = null;
                            if (bits.length > skip + 1) {
                                qualifier = bits[skip + 1];
                            }
                            try {
                                this._location = CSCommon.getLocation(ctx, conn, qualifier);
                                if (this._location != null) {
                                    this._location.connect();
                                    this._location.delete(null);
                                    try {
                                        csUrl = CSCommon.getCloudStorageUrl(ctx, qualifier);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ctx.write(CommandMessages.format("CS_DELETE_OBJ", csUrl.getFinalUrl()) + NL);
                                }
                            }
                            catch (IOException se) {
                                String msg = se.getLocalizedMessage();
                                if (se.getCause() != null && se.getCause().getLocalizedMessage() != null) {
                                    msg = se.getCause().getLocalizedMessage();
                                }
                                ctx.write(CommandMessages.getString("CS_DELETE_ERR") + NL + msg + NL);
                            }
                            catch (Exception e) {
                                ctx.write(CommandMessages.getString("CS_DELETE_ERR") + NL + e.getLocalizedMessage() + NL);
                                return true;
                            }
                            return true;
                        }
                        case "get": {
                            qualifier = null;
                            dirLocation = null;
                            String targetDir = null;
                            Path targetPath = null;
                            if (bits.length > skip + 1 && (bits[skip + 1].equalsIgnoreCase(DBDIR) || bits[skip + 1].equalsIgnoreCase(DBDIRECTORY))) {
                                if (bits.length < skip + 2) {
                                    throw new IOException(CommandMessages.getString("CS_DBDIR_ERR"));
                                }
                                dirLocation = CSCommon.getDbDirectoryLocation(conn);
                                targetDir = bits[skip + 2];
                            } else if (bits.length > skip + 2 && (bits[skip + 2].equals(DBDIR) || bits[skip + 2].equals(DBDIRECTORY))) {
                                if (bits.length < skip + 3) {
                                    throw new IOException(CommandMessages.getString("CS_DBDIR_ERR"));
                                }
                                qualifier = bits[skip + 1];
                                dirLocation = CSCommon.getDbDirectoryLocation(conn);
                                targetDir = bits[skip + 3];
                            } else if (bits.length > skip + 1) {
                                qualifier = bits[skip + 1];
                            }
                            try (Location csLocation = CSCommon.getLocation(ctx, conn, qualifier);){
                                if (csLocation != null) {
                                    csUrl = CSCommon.getCloudStorageUrl(ctx, qualifier);
                                    String localFile = csUrl.getObject();
                                    csLocation.connect();
                                    InputStream is = csLocation.asInputStream(null, 0L, 0L);
                                    if (dirLocation == null) {
                                        localFile = ctx.prependCD(localFile);
                                        targetPath = new File(localFile).toPath();
                                        Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
                                    } else {
                                        dirLocation.copy(is, targetDir + "/" + localFile);
                                    }
                                    ctx.write(CommandMessages.format("CS_GET_OBJ", localFile, csUrl.getFinalUrl()) + NL);
                                } else {
                                    ctx.write(CommandMessages.getString("CS_GET_ERR") + NL);
                                }
                            }
                            catch (IOException se) {
                                String msg = se.getLocalizedMessage();
                                if (se.getCause() != null && se.getCause().getLocalizedMessage() != null) {
                                    msg = se.getCause().getLocalizedMessage();
                                }
                                ctx.write(CommandMessages.getString("CS_GET_ERR") + NL + msg + NL);
                            }
                            catch (Exception e) {
                                ctx.write(CommandMessages.getString("CS_GET_ERR") + NL + e.getLocalizedMessage() + NL);
                                ctx.write(CommandMessages.getString("CS_GET_ERR") + NL + e.getCause().getLocalizedMessage() + NL);
                            }
                            return true;
                        }
                        case "oci": {
                            String profile = (String)ctx.getProperty("oci.profile.name");
                            String section = "ROOT";
                            if (bits.length < skip + 2) {
                                if (profile == null) {
                                    this.writeFormatMissing(ctx, bits[skip]);
                                    return true;
                                }
                                bits = this.nextBits(bits, skip + 1);
                                CSCommon.setTransferAndWarn(ctx, "transfer.oci", false);
                            } else {
                                section = bits[skip + 1];
                                if (this.validateProfile(ctx, section)) {
                                    bits = this.nextBits(bits, skip + 2);
                                } else {
                                    ctx.write(CommandMessages.getString("OCI_PROFILE_INVALID"));
                                    return true;
                                }
                            }
                            CSCommon.setProfileAndWarn(ctx, section, false);
                            this.handleShow(ctx, null);
                            return true;
                        }
                        case "help": {
                            ctx.write(this.getHelp());
                            bits = this.nextBits(bits, skip + 1);
                            return true;
                        }
                        case "listb": 
                        case "listbuckets": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return true;
                            }
                            this._props.put("qualifier", bits[skip + 1]);
                            listType = option.substring(option.length() - 1);
                            this.writeList(ctx, listType);
                            bits = this.nextBits(bits, skip + 2);
                            return true;
                        }
                        case "listc": 
                        case "listcompartments": {
                            if (bits.length > skip + 1) {
                                this._props.put("qualifier", bits[skip + 1]);
                                bits = this.nextBits(bits, skip + 1);
                            }
                            listType = option.substring(option.length() - 1);
                            this.writeList(ctx, listType);
                            bits = this.nextBits(bits, skip + 1);
                            return true;
                        }
                        case "listo": 
                        case "listobjects": {
                            if (bits.length > skip + 1) {
                                try {
                                    this._location = CSCommon.getLocation(ctx, conn, bits[skip + 1]);
                                }
                                catch (Exception e) {
                                    String error = e.getLocalizedMessage();
                                    ctx.write(NL + error + NL);
                                    return true;
                                }
                                bits = this.nextBits(bits, skip + 1);
                            }
                            listType = option.substring(option.length() - 1);
                            bits = this.nextBits(bits, skip + 1);
                            this.writeList(ctx, listType);
                            return true;
                        }
                        case "peek": {
                            if (!(bits.length <= skip + 1 || bits[skip + 1].equalsIgnoreCase(POSITION) || bits[skip + 1].equalsIgnoreCase(POS) || bits[skip + 1].equalsIgnoreCase(SIZE))) {
                                this._props.put("qualifier", bits[skip + 1]);
                                bits = this.nextBits(bits, skip + 1);
                            }
                            if (bits.length > skip + 4) {
                                if (bits[skip + 1].equalsIgnoreCase(POSITION) || bits[skip + 1].equalsIgnoreCase(POS)) {
                                    this._sPos = bits[skip + 2];
                                    bits = this.nextBits(bits, skip + 2);
                                } else if (bits[skip + 1].equalsIgnoreCase(SIZE)) {
                                    this._sSize = bits[skip + 2];
                                    bits = this.nextBits(bits, skip + 2);
                                }
                            }
                            if (bits.length > skip + 2) {
                                if (bits[skip + 1].equalsIgnoreCase(SIZE)) {
                                    this._sSize = bits[skip + 2];
                                    bits = this.nextBits(bits, skip + 2);
                                } else if (bits[skip + 1].equalsIgnoreCase(POSITION) || bits[skip + 1].equalsIgnoreCase(POS)) {
                                    this._sPos = bits[skip + 2];
                                    bits = this.nextBits(bits, skip + 2);
                                }
                            }
                            bits = this.nextBits(bits, skip + 1);
                            this.writePeek(ctx);
                            this._props.remove("qualifier");
                            return true;
                        }
                        case "put": {
                            String bodyFile = null;
                            File srcFile = null;
                            qualifier = null;
                            dirLocation = null;
                            Path dirPath = null;
                            if (bits.length > skip + 1 && (bits[skip + 1].equalsIgnoreCase(DBDIR) || bits[skip + 1].equalsIgnoreCase(DBDIRECTORY))) {
                                if (bits.length < skip + 2) {
                                    throw new IOException(CommandMessages.getString("CS_DBDIR_ERR"));
                                }
                                if (bits.length > skip + 2) {
                                    qualifier = bits[skip + 3];
                                }
                                if (!bits[skip + 2].contains("/")) {
                                    throw new IOException(CommandMessages.getString("CS_DBDIR_ERR"));
                                }
                                dirLocation = CSCommon.getDbDirectoryLocation(conn);
                                bodyFile = bits[skip + 2];
                                dirPath = new File(bits[skip + 2]).toPath();
                            } else if (bits.length > skip + 1) {
                                bodyFile = bits[skip + 1];
                                srcFile = new File(bodyFile = ctx.prependCD(bodyFile));
                                if (!srcFile.isFile()) {
                                    throw new IOException(bodyFile + " is not a file");
                                }
                                if (bits.length > skip + 2) {
                                    qualifier = bits[skip + 2];
                                }
                            } else {
                                CSCommon.writeFormatMissing(ctx, bits[skip]);
                                return true;
                            }
                            try (BufferedInputStream is = new BufferedInputStream(dirLocation == null ? new FileInputStream(srcFile) : ((Location)dirLocation).asInputStream(dirPath, -1L, -1L));){
                                this._location = CSCommon.getLocation(ctx, conn, qualifier);
                                if (this._location != null) {
                                    this._location.connect();
                                    this._location.copy(is, null);
                                    try {
                                        csUrl = CSCommon.getCloudStorageUrl(ctx, qualifier);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ctx.write(CommandMessages.format("CS_PUT_OBJ", csUrl.getFinalUrl(), bodyFile) + NL);
                                }
                            }
                            catch (IOException se) {
                                String msg = se.getLocalizedMessage();
                                if (se.getCause() != null && se.getCause().getLocalizedMessage() != null) {
                                    msg = se.getCause().getLocalizedMessage();
                                }
                                ctx.write(CommandMessages.getString("CS_PUT_ERR") + NL + msg + NL);
                            }
                            catch (Exception e) {
                                ctx.write(CommandMessages.getString("CS_PUT_ERR") + NL + e.getLocalizedMessage() + NL);
                                return true;
                            }
                            return true;
                        }
                        case "show": {
                            qualifier = "";
                            if (bits.length > skip + 1 && (bits[skip + 1].equals("qualifier") || bits[skip + 1].equals("q"))) {
                                qualifier = bits[skip + 2];
                                bits = this.nextBits(bits, skip + 2);
                            } else {
                                bits = this.nextBits(bits, skip + 1);
                            }
                            this.handleShow(ctx, qualifier);
                            return true;
                        }
                        case "uri": 
                        case "url": {
                            if (bits.length < skip + 1) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return true;
                            }
                            try {
                                this._props.put(CLOUD_STR, bits[skip + 1]);
                                cloudUrl = new CloudStorageUrl(bits[skip + 1]);
                                this._props.put(CLOUD_URL, cloudUrl);
                            }
                            catch (Exception e) {
                                String error = e.getLocalizedMessage();
                                ctx.write(NL + bits[skip + 1] + error);
                                return true;
                            }
                            bits = this.nextBits(bits, skip + 2);
                            this.handleShow(ctx, null);
                            return true;
                        }
                    }
                    try {
                        this._props.put(CLOUD_STR, bits[skip]);
                        cloudUrl = new CloudStorageUrl(bits[skip]);
                        this._props.put(CLOUD_URL, cloudUrl);
                    }
                    catch (Exception e) {
                        String error = e.getLocalizedMessage();
                        ctx.write(NL + error + NL);
                        return true;
                    }
                    bits = this.nextBits(bits, skip + 1);
                    this.handleShow(ctx, null);
                }
                catch (Exception e) {
                    String msg = e.getLocalizedMessage();
                    ctx.write(NL + msg + NL);
                    this.writeFormatBad(ctx, (bits.length > 0 ? bits[skip] : "") + NL);
                    return true;
                }
                skip = 0;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeList(ScriptRunnerContext ctx, String listType) {
        try {
            if (this._location == null) {
                this._location = CSCommon.getLocation(ctx, this._conn);
            }
            if (this._location != null) {
                this._location.connect();
                List<Map<?, ?>> list = this._location.list(listType, (String)this._props.get("qualifier"));
                if (list != null) {
                    ctx.write(NL);
                    for (int i = 0; i < list.size(); ++i) {
                        Map<?, ?> entry = list.get(i);
                        String name = (String)entry.get("name");
                        String bytes = (String)entry.get("bytes");
                        ctx.write(name + (String)(bytes == null ? "" : SPACE + bytes) + NL);
                    }
                }
            }
        }
        catch (IOException se) {
            String msg = se.getLocalizedMessage();
            if (se.getCause() != null && se.getCause().getLocalizedMessage() != null) {
                msg = se.getCause().getLocalizedMessage();
            }
            ctx.write(msg + NL);
        }
        catch (Exception e) {
            ctx.write(NL + e.getLocalizedMessage() + NL);
        }
        finally {
            if (this._location != null) {
                this._location.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePeek(ScriptRunnerContext ctx) {
        InputStream inputStream = null;
        try {
            if (this._location == null) {
                this._location = CSCommon.getLocation(ctx, this._conn, (String)this._props.get("qualifier"));
            }
            if (this._location != null) {
                this._location.connect();
                long pos = 0L;
                long size = 2000L;
                if (this._sPos != null && !this._sPos.isEmpty()) {
                    pos = Long.parseLong(this._sPos);
                }
                if (this._sSize != null && !this._sSize.isEmpty()) {
                    size = Long.parseLong(this._sSize);
                }
                inputStream = this._location.asInputStream(null, pos, size);
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer data = new StringBuffer();
                char[] buffer = new char[1];
                while (reader.read(buffer) != -1) {
                    data.append(buffer);
                }
                ctx.write(NL);
                ctx.write(data.toString());
                ctx.write(NL);
            }
        }
        catch (IOException se) {
            String msg = se.getLocalizedMessage();
            if (se.getCause() != null && se.getCause().getLocalizedMessage() != null) {
                msg = se.getCause().getLocalizedMessage();
            }
            ctx.write(CommandMessages.getString("CS_PEEK_ERR") + NL + msg + NL);
        }
        catch (Exception e) {
            ctx.write(NL + e.getLocalizedMessage() + NL);
        }
        finally {
            if (this._location != null) {
                this._location.disconnect();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                String error = e.getLocalizedMessage();
                ctx.write(NL + error + NL);
            }
        }
    }

    private void writeFormatMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(CommandMessages.format("CSMISSINGVALUE", option) + NL);
    }

    private void writeFormatBad(ScriptRunnerContext ctx, String option) {
        ctx.write(CommandMessages.format("CSFORMATBAD", option) + NL);
    }

    private String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    private boolean isAnyOption(String word) {
        try {
            switch (word) {
                case "dbcc": 
                case "dbccred": 
                case "dbc_cred": 
                case "oci": 
                case "swift": 
                case "cloud_url": {
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean validateProfile(ScriptRunnerContext ctx, String section) {
        OCIProfiles profiles = new OCIProfiles();
        try {
            ArrayList sections = profiles.getProfiles();
            return sections.contains(section);
        }
        catch (Exception e) {
            ctx.write("CSPROFILE_ERROR" + e.getLocalizedMessage());
            return false;
        }
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String cmdTrimmed = cmd.getLoweredTrimmedNoWhitespaceSQL();
        if (cmdTrimmed.startsWith("showcs") || cmdTrimmed.startsWith("showcloudstorage") || cmdTrimmed.startsWith("showcloud_storage")) {
            this.handleShow(ctx, null);
            return true;
        }
        return false;
    }

    public void handleShow(ScriptRunnerContext ctx, String qualifier) {
        this._props = (Map)ctx.getProperty("cloud.storage");
        if (this._props == null) {
            this._props = new HashMap<String, Object>();
        } else {
            this._props.remove("qualifier");
        }
        this._props.put("qualifier", qualifier);
        CloudStorageCommand.showParms(ctx, this._props);
    }

    public static void showParms(ScriptRunnerContext ctx, Map<String, Object> props) {
        String transfer = (String)props.get("transfer");
        Object show = "";
        String credential = (String)props.get("dbms.cloud.credential");
        show = credential == null || credential.isEmpty() ? (String)show + CommandMessages.getString("CSMISSING_CREDENTIAL") + NL : (String)show + CommandMessages.getString("CSCREDENTIAL") + SPACE + credential + NL;
        String profile = (String)ctx.getProperty("oci.profile.name");
        show = profile == null || profile.isEmpty() ? (String)show + CommandMessages.getString("CSMISSING_PROFILE") + NL : (String)show + CommandMessages.getString("CSPROFILE") + SPACE + profile + NL;
        show = (String)show + CommandMessages.getString("DBC_TRANSFER_METHOD");
        if (transfer == null) {
            show = (String)show + SPACE + CommandMessages.getString("DBC_TRANSFER_MISSING") + NL;
        } else {
            try {
                switch (transfer) {
                    case "transfer.dbms_cloud": {
                        show = (String)show + " dbms_cloud\n";
                        break;
                    }
                    case "transfer.oci": {
                        show = (String)show + " oci\n";
                        break;
                    }
                    default: {
                        show = (String)show + SPACE + CommandMessages.getString("DBC_TRANSFER_MISSING") + NL;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String cloudStr = (String)props.get(CLOUD_STR);
        show = cloudStr != null && !cloudStr.isEmpty() ? (String)show + CommandMessages.getString("CSURL_SPEC") + SPACE + cloudStr + NL : (String)show + CommandMessages.getString("CSMISSING_URL") + NL;
        CloudStorageUrl csUrl = (CloudStorageUrl)props.get(CLOUD_URL);
        String qualifier = (String)props.get("qualifier");
        try {
            if (qualifier != null && !qualifier.isEmpty()) {
                show = (String)show + "QUALIFIER: " + qualifier + NL;
                if (csUrl == null) {
                    csUrl = new CloudStorageUrl(qualifier);
                } else {
                    csUrl.qualifiedUrl(qualifier);
                    URL cloudUrl = csUrl.getFinalUrlAsOCI();
                    show = (String)show + CommandMessages.getString("CSOCIURL") + SPACE + (cloudUrl == null ? "" : cloudUrl.toString()) + NL;
                }
            }
        }
        catch (Exception e) {
            String error = e.getLocalizedMessage();
            show = (String)show + NL + CommandMessages.getString("CSOCIURL") + SPACE + error;
        }
        ctx.write((String)show);
        ctx.write("");
    }

    public String[] getShowAliases() {
        return new String[]{CS, CLOUDSTORAGE, CLOUD_STORAGE};
    }

    public boolean needsDatabase() {
        return false;
    }

    public boolean inShowAll() {
        return true;
    }
}

