/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.installer.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.io.InputOutputStreams;

public final class MavenCoordinates {
    private static final Pattern AUTOMATIC_MODULE_PATTERN = Pattern.compile("-(\\d+(\\.|$))");
    private static final String UNKNOWN = "unknown";
    private final String artifactId;
    private final String groupId;
    private final String version;

    private MavenCoordinates(Builder builder) {
        this.artifactId = builder.artifactId;
        this.groupId = builder.groupId;
        this.version = builder.version;
    }

    static MavenCoordinates of(Path jar) throws IOException {
        try (BufferedInputStream content = new BufferedInputStream(Files.newInputStream(jar, new OpenOption[0]), 8192);){
            MavenCoordinates coordinates = MavenCoordinates.of(content);
            if (coordinates == null) {
                MavenCoordinates mavenCoordinates = MavenCoordinates.fileBasedCoordinates(jar.getFileName().toString());
                return mavenCoordinates;
            }
            MavenCoordinates mavenCoordinates = coordinates;
            return mavenCoordinates;
        }
    }

    private static MavenCoordinates fileBasedCoordinates(String jarName) {
        String name = jarName.substring(0, jarName.length() - ".jar".length());
        Matcher matcher = AUTOMATIC_MODULE_PATTERN.matcher(name);
        if (matcher.find()) {
            String artifactId = name.substring(0, matcher.start());
            String version = name.substring(matcher.start() + 1);
            return MavenCoordinates.builder().artifactId(artifactId).version(version).build();
        }
        return MavenCoordinates.builder().artifactId(name).build();
    }

    static MavenCoordinates of(InputStream content) throws IOException {
        ZipInputStream zip = new ZipInputStream(content);
        ZipEntry zipEntry = zip.getNextEntry();
        while (zipEntry != null) {
            String name = zipEntry.getName();
            if (name.startsWith("META-INF/maven/") && name.endsWith("/pom.properties")) {
                ConfigurationProperties properties = ConfigurationProperties.read((InputStream)zip);
                String artifactId = properties.getProperty((CharSequence)"artifactId");
                String groupId = properties.getProperty((CharSequence)"groupId");
                String version = properties.getProperty((CharSequence)"version");
                return MavenCoordinates.builder().artifactId(artifactId).groupId(groupId).version(version).build();
            }
            zip.transferTo(InputOutputStreams.instance().nullOutputStream());
            zipEntry = zip.getNextEntry();
        }
        return null;
    }

    public static void main(String ... args) throws Exception {
        Path root = Paths.get(args[0], new String[0]);
        PrintStream out = System.out;
        try (Stream<Path> children = Files.walk(root, new FileVisitOption[0]).filter(MavenCoordinates::isJar);){
            children.forEach(child -> MavenCoordinates.report(child, out));
        }
    }

    private static void report(Path jar, PrintStream out) {
        try {
            MavenCoordinates mavenJar = MavenCoordinates.of(jar);
            if (mavenJar == null) {
                out.println(String.valueOf(jar) + ": could not determine Maven coordinates");
            } else {
                out.println(String.valueOf(jar) + ": " + String.valueOf(mavenJar));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isJar(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String groupId() {
        return this.groupId;
    }

    public String version() {
        return this.version;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenCoordinates mavenJar = (MavenCoordinates)o;
        return Objects.equals(this.artifactId, mavenJar.artifactId) && Objects.equals(this.groupId, mavenJar.groupId) && Objects.equals(this.version, mavenJar.version);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.groupId, this.version);
    }

    public static final class Builder {
        private String artifactId = "unknown";
        private String groupId = "unknown";
        private String version = "unknown";

        private Builder() {
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public MavenCoordinates build() {
            return new MavenCoordinates(this);
        }
    }
}

