/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl.cache;

import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.cache.DescriptorCache;
import oracle.soda.rdbms.impl.cache.LRUCache;

class SynchronizedDescriptorCache
implements DescriptorCache {
    private final LRUCache<String, CollectionDescriptor> cache;

    public SynchronizedDescriptorCache(int n) {
        this.cache = new LRUCache(n);
    }

    @Override
    public synchronized CollectionDescriptor get(String string) {
        return (CollectionDescriptor)this.cache.get(string);
    }

    @Override
    public synchronized CollectionDescriptor putIfAbsent(CollectionDescriptor collectionDescriptor) {
        String string = collectionDescriptor.getName();
        if (this.cache.containsKey(string)) {
            return (CollectionDescriptor)this.cache.get(string);
        }
        this.cache.put(string, collectionDescriptor);
        return null;
    }

    @Override
    public synchronized CollectionDescriptor put(CollectionDescriptor collectionDescriptor) {
        String string = collectionDescriptor.getName();
        return this.cache.put(string, collectionDescriptor);
    }

    @Override
    public synchronized boolean containsDescriptor(String string) {
        return this.cache.containsKey(string);
    }

    @Override
    public synchronized void remove(String string) {
        this.cache.remove(string);
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }
}

