/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl.cache;

import java.util.concurrent.ConcurrentHashMap;
import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;
import oracle.soda.rdbms.impl.cache.ConcurrentDescriptorCache;
import oracle.soda.rdbms.impl.cache.DescriptorCache;

public class ConcurrentCacheOfDescriptorCaches
implements CacheOfDescriptorCaches {
    private final ConcurrentHashMap<String, DescriptorCache> cacheOfDescriptorCaches = new ConcurrentHashMap(10);
    private final int numberOfDescriptors;

    public ConcurrentCacheOfDescriptorCaches(int n) {
        this.numberOfDescriptors = n;
    }

    @Override
    public DescriptorCache putIfAbsentAndGet(String string) {
        DescriptorCache descriptorCache = this.cacheOfDescriptorCaches.get(string);
        if (descriptorCache != null) {
            return descriptorCache;
        }
        ConcurrentDescriptorCache concurrentDescriptorCache = new ConcurrentDescriptorCache(this.numberOfDescriptors);
        descriptorCache = this.cacheOfDescriptorCaches.putIfAbsent(string, concurrentDescriptorCache);
        return descriptorCache != null ? descriptorCache : concurrentDescriptorCache;
    }

    @Override
    public DescriptorCache remove(String string) {
        return this.cacheOfDescriptorCaches.remove(string);
    }

    @Override
    public void clear() {
        for (DescriptorCache descriptorCache : this.cacheOfDescriptorCaches.values()) {
            descriptorCache.clear();
        }
    }

    @Override
    public void clear(String string) {
        DescriptorCache descriptorCache = this.cacheOfDescriptorCaches.get(string);
        if (descriptorCache != null) {
            descriptorCache.clear();
        }
    }
}

