/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonParser;

public class JsonpParserWrapper
implements JsonParser {
    OracleJsonParser wrapped;

    public JsonpParserWrapper(OracleJsonParser oracleJsonParser) {
        this.wrapped = oracleJsonParser;
    }

    public void close() {
        try {
            this.wrapped.close();
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
    }

    public OracleJsonParser getWrapped() {
        return this.wrapped;
    }

    public BigDecimal getBigDecimal() {
        return this.wrapped.getBigDecimal();
    }

    public int getInt() {
        return this.wrapped.getInt();
    }

    public JsonLocation getLocation() {
        JsonLocation jsonLocation = new JsonLocation(){

            public long getColumnNumber() {
                return -1L;
            }

            public long getLineNumber() {
                return -1L;
            }

            public long getStreamOffset() {
                if (JsonpParserWrapper.this.wrapped instanceof OsonParserImpl) {
                    return ((OsonParserImpl)JsonpParserWrapper.this.wrapped).getStreamOffset();
                }
                return -1L;
            }
        };
        return jsonLocation;
    }

    public long getLong() {
        return this.wrapped.getLong();
    }

    public String getString() {
        return this.wrapped.getString();
    }

    public boolean hasNext() {
        try {
            return this.wrapped.hasNext();
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
    }

    public boolean isIntegralNumber() {
        return this.wrapped.isIntegralNumber();
    }

    public JsonParser.Event next() {
        OracleJsonParser.Event event;
        try {
            event = this.wrapped.next();
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
        switch (event) {
            case END_ARRAY: {
                return JsonParser.Event.END_ARRAY;
            }
            case END_OBJECT: {
                return JsonParser.Event.END_OBJECT;
            }
            case KEY_NAME: {
                return JsonParser.Event.KEY_NAME;
            }
            case START_ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case START_OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case VALUE_DOUBLE: 
            case VALUE_FLOAT: 
            case VALUE_DECIMAL: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case VALUE_FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case VALUE_TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
            case VALUE_NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
        }
        return JsonParser.Event.VALUE_STRING;
    }

    public JsonValue getValue() {
        try {
            return (JsonValue)this.wrapped.getValue().wrap(JsonValue.class);
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
    }

    public JsonObject getObject() {
        try {
            return (JsonObject)this.wrapped.getObject().wrap(JsonObject.class);
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
    }

    public JsonArray getArray() {
        try {
            return (JsonArray)this.wrapped.getArray().wrap(JsonArray.class);
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
    }

    public void skipObject() {
        try {
            this.wrapped.skipObject();
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
    }

    public void skipArray() {
        try {
            this.wrapped.skipArray();
        }
        catch (OracleJsonException oracleJsonException) {
            throw new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
    }
}

