/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

public abstract class ObjectDetails {
    private final String bucketName;
    private final String cacheControl;
    private final ChecksumAlgorithm checksumAlgorithm;
    private final String checksumContent;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentMD5;
    private final String contentType;
    private final String eTag;
    private final String namespace;
    private final String opcClientRequestId;
    private final StorageTier storageTier;
    protected static final String NEW_LINE = System.getProperty("line.separator");

    protected ObjectDetails(Builder builder) {
        this.bucketName = builder.bucketName;
        this.cacheControl = builder.cacheControl;
        this.checksumAlgorithm = builder.checksumAlgorithm;
        this.checksumContent = builder.checksumContent;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentMD5 = builder.contentMD5;
        this.contentType = builder.contentType;
        this.eTag = builder.eTag;
        this.namespace = builder.namespace;
        this.opcClientRequestId = builder.opcClientRequestId;
        this.storageTier = builder.storageTier;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getChecksumAlgorithm() {
        if (this.checksumAlgorithm != null) {
            return this.checksumAlgorithm.toString();
        }
        return null;
    }

    public String getChecksumContent() {
        return this.checksumContent;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getStorageTier() {
        if (this.storageTier != null) {
            return this.storageTier.toString();
        }
        return null;
    }

    public static abstract class Builder<T extends Builder, C> {
        protected final String bucketName;
        protected final String namespace;
        protected String eTag;
        private String cacheControl;
        private ChecksumAlgorithm checksumAlgorithm;
        private String checksumContent;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String contentMD5;
        private String contentType;
        private String opcClientRequestId;
        private StorageTier storageTier;

        protected Builder(String namespace, String bucketName) {
            this.namespace = namespace;
            this.bucketName = bucketName;
        }

        public T cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return (T)this;
        }

        public Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        public Builder checksumContent(String checksumContent) {
            this.checksumContent = checksumContent;
            return this;
        }

        public T contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return (T)this;
        }

        public T contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return (T)this;
        }

        public T contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return (T)this;
        }

        public T contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return (T)this;
        }

        public T contentType(String contentType) {
            this.contentType = contentType;
            return (T)this;
        }

        public T eTag(String eTag) {
            this.eTag = eTag;
            return (T)this;
        }

        public T opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return (T)this;
        }

        public T storageTier(StorageTier storageTier) {
            this.storageTier = storageTier;
            return (T)this;
        }

        public abstract C build();
    }

    public static enum ChecksumAlgorithm {
        CRC32C,
        SHA256,
        SHA384;

    }

    public static enum StorageTier {
        Standard,
        InfrequentAccess,
        Archive;

    }
}

