/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.connections;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.util.StoredConnectionSupport;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIClientException;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.core.oci.search.OCISearchClient;
import oracle.dbtools.core.oci.search.ResourceQuery;
import oracle.dbtools.core.oci.search.SearchResult;

public class OCIStoredConnectionSupport
extends StoredConnectionSupport {
    public static final ResourceQuery.ResourceQueryConstraint ORACLE_DATABASES = ResourceQuery.likeConstraint("type", "ORACLE_DATABASE");
    private final OCISearchClient searchClient;

    public static Builder builder() {
        return new Builder();
    }

    private OCIStoredConnectionSupport(Builder builder) {
        super(builder.storage != null ? builder.storage : ConnectionStorage.instance());
        this.searchClient = OCISearchClient.of(builder.profile, builder.region);
    }

    public Collection<SearchResult> listConnections() {
        return this.listConnections(ResourceQuery.unconstrained());
    }

    public Collection<SearchResult> listConnections(ResourceQuery.ResourceQueryConstraint constraint) {
        ResourceQuery query = ResourceQuery.databaseToolsQuery(constraint);
        return this.searchClient.listResources(query);
    }

    public ConnectionDefinition createConnectionDefinition(SearchResult result) {
        return this.createConnectionDefinition(result, result.getDisplayName());
    }

    public ConnectionDefinition createConnectionDefinition(SearchResult result, String nameOverride) {
        AuthenticationProvider authenticationProvider = this.searchClient.getAuthenticationProvider();
        ConfigurationProperties.Builder builder = ConfigurationProperties.builder().set((CharSequence)"name", nameOverride).set((CharSequence)"type", "OCI_DBTOOLS");
        builder = builder.set((CharSequence)"ociAuthenticationMethod", authenticationProvider.getAuthenticationType());
        if (Objects.equals(authenticationProvider.getAuthenticationType(), "PROFILE")) {
            builder = builder.set((CharSequence)"ociProfile", authenticationProvider.getAuthenticationProperty("ProfileName"));
        }
        builder = builder.set((CharSequence)"ociRegion", this.searchClient.getRegion()).set((CharSequence)"databaseToolsConnectionId", result.getResourceId());
        ConfigurationProperties configurationProperties = builder.build();
        return ConnectionDefinition.builder((Connections.Identifier)ConnectionIdentifiers.createUniqueIdentifier()).dbtoolsProperties(configurationProperties).build();
    }

    public void storeConnection(SearchResult result) {
        this.storeConnection(result, null);
    }

    public void storeConnection(SearchResult result, String nameOverride) {
        ConnectionDefinition definition = nameOverride != null ? this.createConnectionDefinition(result, nameOverride) : this.createConnectionDefinition(result);
        this.storeConnection(definition);
    }

    public static class Builder {
        private OCIProfile profile;
        private String region;
        private ConnectionStorage storage;

        private Builder() {
        }

        public Builder ociProfile(String profileName) {
            try {
                OCIProfiles profiles = OCIProfiles.builder().build();
                this.profile = profiles.getProfile(profileName);
                if (this.profile == null) {
                    throw OCIClientException.of("Profile " + profileName + " does not exist");
                }
            }
            catch (IOException e) {
                throw OCIClientException.of(e);
            }
            return this;
        }

        public Builder ociRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder connectionStorage(ConnectionStorage storage) {
            this.storage = storage;
            return this;
        }

        public OCIStoredConnectionSupport build() {
            return new OCIStoredConnectionSupport(this);
        }
    }
}

