/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PrivateEndpointConfiguration {
    private static final Pattern PORT_PATTERN = Pattern.compile("(?i)(\\(\\s*PORT\\s*=)\\s*(\\d+)\\s*(\\))");
    private static final Pattern HOST_PATTERN = Pattern.compile("(?i)(\\(\\s*HOST\\s*=)\\s*([^\\s)]+)\\s*(\\))");
    private static final Pattern EZ_CONNECT_PATTERN = Pattern.compile("(?i)([^:/]*)(:?)(\\d*)([:/])([^?]*)");
    private final String originalConnectString;
    private final String connectStringUpdatedHost;
    private final String endpointIP;
    private final String host;
    private final int targetPort;
    private final Function<Integer, String> portUpdater;

    static Builder builder() {
        return new Builder();
    }

    private PrivateEndpointConfiguration(Builder builder) throws IOException {
        this.originalConnectString = builder.originalConnectString;
        String connectPort = null;
        String connectHost = null;
        String updatedString = null;
        Matcher hostMatcher = HOST_PATTERN.matcher(this.originalConnectString);
        Matcher ezMatcher = EZ_CONNECT_PATTERN.matcher(this.originalConnectString);
        if (hostMatcher.find()) {
            connectHost = hostMatcher.group(2);
            updatedString = hostMatcher.replaceFirst("$1 localhost $3");
            Matcher portMatcher = PORT_PATTERN.matcher(this.originalConnectString);
            if (portMatcher.find()) {
                connectPort = portMatcher.group(2);
            }
            this.portUpdater = this::updateDescriptorWithPort;
        } else if (ezMatcher.find()) {
            connectHost = ezMatcher.group(1);
            connectPort = ezMatcher.group(3);
            updatedString = ezMatcher.replaceFirst("localhost$2$3$4$5");
            this.portUpdater = this::updateEzConnectWithPort;
        } else {
            throw new IOException("unable to determine connect string format");
        }
        if (connectHost == null) {
            throw new IOException("unable to determine host from connect string");
        }
        this.host = connectHost;
        int port = -1;
        try {
            port = Integer.parseInt(connectPort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (port <= 0) {
            throw new IOException("cannot get port from connect string");
        }
        if (updatedString == null) {
            throw new IOException("unable to update connection string hostname for endpoint support");
        }
        this.targetPort = port;
        this.endpointIP = builder.endpointIP;
        this.connectStringUpdatedHost = updatedString;
    }

    int getTargetPort() {
        return this.targetPort;
    }

    String getEndpointIP() {
        return this.endpointIP;
    }

    String getHost() {
        return this.host;
    }

    String updateDescriptorWithPort(int port) {
        Matcher portMacher = PORT_PATTERN.matcher(this.connectStringUpdatedHost);
        if (!portMacher.find()) {
            throw new UncheckedIOException(new IOException("Oops, how do we not have a port?"));
        }
        return portMacher.replaceFirst("$1 " + port + " $3");
    }

    String updateEzConnectWithPort(int port) {
        Matcher portMacher = EZ_CONNECT_PATTERN.matcher(this.connectStringUpdatedHost);
        if (!portMacher.find()) {
            throw new UncheckedIOException(new IOException("Oops, how do we not have a port?"));
        }
        return portMacher.replaceFirst("$1$2" + port + "$4$5");
    }

    String updateConnectStringWithPort(int port) throws IOException {
        try {
            return this.portUpdater.apply(port);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    static class Builder {
        private String originalConnectString;
        private String endpointIP;

        Builder() {
        }

        Builder originalConnectString(String connectString) {
            this.originalConnectString = connectString;
            return this;
        }

        Builder endpointIP(String endpointIP) {
            this.endpointIP = endpointIP;
            return this;
        }

        PrivateEndpointConfiguration build() throws IOException {
            return new PrivateEndpointConfiguration(this);
        }
    }
}

