/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.RegionSubscription;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListRegionSubscriptionsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListRegionSubscriptionsResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCICompartment;
import oracle.dbtools.core.oci.OCIObject;
import oracle.dbtools.core.oci.OCIProfile;

public final class OCIIdentityClient
extends OCIClient {
    private final IdentityClient client = (IdentityClient)this.createClient(IdentityClient.builder());

    public static Builder builder(OCIProfile profile) {
        return new Builder(profile);
    }

    private OCIIdentityClient(Builder builder) {
        super(builder);
    }

    public List<RegionIdentifier> listRegions() throws IOException {
        String tenantId = this.getAuthenticationProvider().getTenantId();
        if (tenantId == null) {
            throw new IllegalStateException("Current tenancy is not configured");
        }
        ListRegionSubscriptionsRequest request = ListRegionSubscriptionsRequest.builder().tenancyId(tenantId).build();
        ListRegionSubscriptionsResponse response = OCIIdentityClient.executeRequest(() -> this.client.listRegionSubscriptions(request));
        return response.getItems().stream().map(x$0 -> new RegionIdentifier((RegionSubscription)x$0)).collect(Collectors.toList());
    }

    public List<String> listCompartments() throws IOException {
        String tenantId = this.getAuthenticationProvider().getTenantId();
        if (tenantId == null) {
            throw new IllegalStateException("Current tenancy is not configured");
        }
        ListCompartmentsRequest request = ListCompartmentsRequest.builder().compartmentId(tenantId).build();
        ListCompartmentsResponse response = OCIIdentityClient.executeRequest(() -> this.client.listCompartments(request));
        return response.getItems().stream().map(Compartment::getName).collect(Collectors.toList());
    }

    public Map<String, OCICompartment> getCompartmentMap() {
        String tenantId = this.getAuthenticationProvider().getTenantId();
        return this.getCompartmentMap(tenantId);
    }

    public Map<String, OCICompartment> getCompartmentMap(String compartmentId) {
        if (compartmentId == null) {
            throw new IllegalStateException("Current tenancy is not configured");
        }
        ListCompartmentsRequest request = ListCompartmentsRequest.builder().compartmentId(compartmentId).build();
        ListCompartmentsResponse response = OCIIdentityClient.executeRequest(() -> this.client.listCompartments(request));
        return response.getItems().stream().map(p -> ((OCICompartment.Builder)((OCICompartment.Builder)((OCICompartment.Builder)OCICompartment.builder().id(p.getId())).compartmentID(p.getCompartmentId())).displayName(p.getName())).build()).collect(Collectors.toMap(OCIObject::getResourceId, Function.identity()));
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCIIdentityClient> {
        private Builder(AuthenticationProvider profile) {
            super(profile);
        }

        @Override
        public OCIIdentityClient build() {
            return new OCIIdentityClient(this);
        }
    }

    public static final class RegionIdentifier {
        private final RegionSubscription regionSubscription;

        private RegionIdentifier(RegionSubscription subscription) {
            this.regionSubscription = subscription;
        }

        public String getRegionName() {
            return this.regionSubscription.getRegionName();
        }

        public boolean isHomeRegion() {
            return this.regionSubscription.getIsHomeRegion();
        }
    }
}

