/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.databasetools.DatabaseToolsClient;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnection;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionOracleDatabase;
import com.oracle.bmc.databasetools.model.DatabaseToolsPrivateEndpoint;
import com.oracle.bmc.databasetools.model.DatabaseToolsRelatedResource;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPassword;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPasswordSecretId;
import com.oracle.bmc.databasetools.model.LifecycleState;
import com.oracle.bmc.databasetools.model.RelatedResourceEntityType;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsPrivateEndpointRequest;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsConnectionResponse;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsPrivateEndpointResponse;
import com.oracle.bmc.model.BmcException;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.stream.IntStream;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIBastionClient;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIClientException;
import oracle.dbtools.core.oci.OCIDBToolsConnection;
import oracle.dbtools.core.oci.OCIDatabaseServiceClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCISecretsClient;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.PrivateEndpointConfiguration;
import oracle.dbtools.core.proxy.ProxyChecker;
import oracle.dbtools.core.secrets.TextSecret;

public final class OCIDatabaseClient
extends OCIClient {
    private static final String JDBC_ORACLE_THIN = "jdbc:oracle:thin:@";
    private static final String JDBC_ORACLE_THICK = "jdbc:oracle:oci:@";
    private final DatabaseToolsClient dbToolsClient = (DatabaseToolsClient)this.createClient(DatabaseToolsClient.builder());
    private final OCISecretsClient secretsClient;
    private final OCIDatabaseServiceClient dbClient;
    private final boolean useThick;
    private final ProxyChecker proxyChecker;

    public static Builder builder(AuthenticationProvider profile) {
        return new Builder(profile);
    }

    public static OCIDatabaseClient of(OCIProfile profile, String regionName) {
        Builder builder = OCIDatabaseClient.builder(profile);
        if (regionName != null) {
            builder.region(regionName);
        }
        return builder.build();
    }

    private OCIDatabaseClient(Builder builder) {
        super(builder);
        this.secretsClient = builder.secretsClient != null ? builder.secretsClient : this.createChildClient(OCISecretsClient::builder).build();
        this.dbClient = builder.databaseClient != null ? builder.databaseClient : this.createChildClient(OCIDatabaseServiceClient::builder).build();
        this.proxyChecker = builder.proxy != null ? builder.proxy : ProxyChecker.builder().build();
        this.useThick = builder.useThick;
    }

    public OCIDBToolsConnection createDBToolsConnection(String ocid) {
        GetDatabaseToolsConnectionResponse connectionResponse;
        GetDatabaseToolsConnectionRequest connectionRequest = GetDatabaseToolsConnectionRequest.builder().databaseToolsConnectionId(ocid).build();
        try {
            OCIUtils.info("Fetching DatabaseTools Connection info (OCID: {0})", ocid);
            connectionResponse = this.dbToolsClient.getDatabaseToolsConnection(connectionRequest);
        }
        catch (BmcException be) {
            OCIUtils.warn("Error fetching DatabaseTools Connection (OCID: {0}; error: {1})", ocid, be.getUnmodifiedMessage());
            Throwable cause = be.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause != null) {
                throw OCIClientException.of(cause);
            }
            StringBuilder sb = new StringBuilder(be.getUnmodifiedMessage()).append("\n");
            sb.append(Messages.getString("OCI_INVALID_OCID"));
            throw OCIClientException.of(sb.toString());
        }
        DatabaseToolsConnection dbToolsConn = connectionResponse.getDatabaseToolsConnection();
        return OCIDBToolsConnection.builder().ocid(ocid).dbtoolsConnection(dbToolsConn).build();
    }

    public DataSourceBuilder createDataSource(DataSourceBuilder builder, OCIDBToolsConnection ocidbToolsConnection) throws SQLException, IOException {
        OCIUtils.info("Creating a datasource for {0}", ocidbToolsConnection.getOCID());
        DatabaseToolsConnection dbToolsConn = ocidbToolsConnection.getDbtoolsConnection();
        if (dbToolsConn instanceof DatabaseToolsConnectionOracleDatabase) {
            this.processOracleDatabase(builder, (DatabaseToolsConnectionOracleDatabase)dbToolsConn);
        }
        return builder;
    }

    private void processOracleDatabase(DataSourceBuilder builder, DatabaseToolsConnectionOracleDatabase oracleDatabase) throws IOException, SQLException {
        String privateEndpointId;
        DatabaseToolsRelatedResource relatedResource;
        Map advProps;
        OCIUtils.info("Processing Oracle DatabaseTools Connection", new Object[0]);
        String connString = oracleDatabase.getConnectionString();
        if (!builder.hasCredentials()) {
            String username = oracleDatabase.getUserName();
            DatabaseToolsUserPassword dbToolsPwd = oracleDatabase.getUserPassword();
            String secretID = dbToolsPwd instanceof DatabaseToolsUserPasswordSecretId ? ((DatabaseToolsUserPasswordSecretId)dbToolsPwd).getSecretId() : null;
            this.processCredentials(builder, username, secretID);
        }
        if ((advProps = oracleDatabase.getAdvancedProperties()) != null) {
            OCIUtils.info("Processing advanced properties set on connection", new Object[0]);
            Properties props = new Properties();
            advProps.entrySet().forEach(e -> props.setProperty((String)e.getKey(), (String)e.getValue()));
            builder.connectionProperties(props);
        }
        if ((relatedResource = oracleDatabase.getRelatedResource()) != null) {
            OCIUtils.info("relatedResource set: {0} ", relatedResource.getEntityType());
            if (RelatedResourceEntityType.Autonomousdatabase.equals((Object)relatedResource.getEntityType())) {
                String identifier = relatedResource.getIdentifier();
                this.handleAutonomousDatabase(builder, identifier);
            }
        }
        if (!OCIUtils.isEmpty(privateEndpointId = oracleDatabase.getPrivateEndpointId())) {
            OCIUtils.info("Found private endpoint (privateEndpointId: {0})", privateEndpointId);
            connString = this.createEndpointTunnel(oracleDatabase, privateEndpointId, connString);
            if (connString == null) {
                throw new IOException(Messages.format("ENDPOINT_ERROR_UNSUPPORTED_CONNECT_STRING", connString));
            }
        } else {
            this.processProxy(builder, connString);
        }
        builder.url((this.useThick ? JDBC_ORACLE_THICK : JDBC_ORACLE_THIN) + connString);
    }

    private String createEndpointTunnel(DatabaseToolsConnectionOracleDatabase oracleDatabase, String privateEndpointId, String connectString) throws IOException {
        String dbIP = null;
        DatabaseToolsRelatedResource relatedResource = oracleDatabase.getRelatedResource();
        if (relatedResource != null && RelatedResourceEntityType.Autonomousdatabase.equals((Object)relatedResource.getEntityType())) {
            String autonomousID = relatedResource.getIdentifier();
            dbIP = this.dbClient.getPrivateEndpointIp(autonomousID);
        }
        GetDatabaseToolsPrivateEndpointRequest privateEndpointRequest = GetDatabaseToolsPrivateEndpointRequest.builder().databaseToolsPrivateEndpointId(privateEndpointId).build();
        GetDatabaseToolsPrivateEndpointResponse privateEndpointResponse = OCIDatabaseClient.executeRequest(() -> this.dbToolsClient.getDatabaseToolsPrivateEndpoint(privateEndpointRequest));
        DatabaseToolsPrivateEndpoint privateEndpoint = privateEndpointResponse.getDatabaseToolsPrivateEndpoint();
        LifecycleState state = privateEndpoint.getLifecycleState();
        OCIUtils.info("Verifying private endpoint state (privateEndpointId: {0}; state: {1}", privateEndpointId, state);
        if (LifecycleState.Active != state) {
            throw new IOException(Messages.format("ENDPOINT_ERROR_INACTIVE_STATE", state));
        }
        String subnetID = privateEndpoint.getSubnetId();
        OCIUtils.info("private endpoint subnet: {0} ", subnetID);
        OCIBastionClient bastionClient = (OCIBastionClient)this.createFrom(OCIBastionClient.builder(this.getAuthenticationProvider()));
        String bastionID = bastionClient.findBastion(oracleDatabase.getCompartmentId(), subnetID);
        if (bastionID == null) {
            OCIUtils.info(Messages.format("ENDPOINT_ERROR_NO_MATCHING_BASTION", subnetID), new Object[0]);
            return connectString;
        }
        String endpointIP = !OCIUtils.isEmpty(dbIP) ? dbIP : privateEndpoint.getPrivateEndpointIp();
        OCIUtils.info("determining remote address to use (endpointIP: {0}; dbIP: {1})", privateEndpoint.getPrivateEndpointIp(), dbIP);
        PrivateEndpointConfiguration endpointConfig = PrivateEndpointConfiguration.builder().endpointIP(endpointIP).originalConnectString(connectString).build();
        try {
            OCIBastionClient.SessionDetails sessionDetails = bastionClient.findOrCreateSession(bastionID, endpointConfig);
            int localPort = bastionClient.openTunnel(endpointConfig, sessionDetails);
            connectString = endpointConfig.updateConnectStringWithPort(localPort);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return connectString;
    }

    private void handleAutonomousDatabase(DataSourceBuilder builder, String identifier) throws IOException, SQLException {
        OCIUtils.info("fetching wallet", new Object[0]);
        OracleWalletArchive wallet = this.dbClient.getWallet(identifier);
        wallet.configure(builder);
    }

    private void processProxy(DataSourceBuilder builder, String connectString) {
        URI proxy = this.proxyChecker.getProxy(connectString);
        if (proxy != null) {
            Properties props = new Properties();
            props.setProperty("oracle.net.httpsProxyHost", proxy.getHost());
            props.setProperty("oracle.net.httpsProxyPort", Integer.toString(proxy.getPort()));
            builder.connectionProperties(props);
        }
    }

    private void processCredentials(DataSourceBuilder builder, String username, String secretID) {
        if (username != null) {
            builder.user(username);
        }
        if (secretID != null) {
            OCIUtils.info("Looking up password from secret store", new Object[0]);
            TextSecret secret = this.getSecret(secretID);
            builder.password(secret);
        }
    }

    public TextSecret getSecret(String secretID) {
        TextSecret secret = TextSecret.none();
        OCIUtils.info("Looking up password from secret store", new Object[0]);
        secret = this.secretsClient.getSecret(secretID);
        return secret;
    }

    public TextSecret getPassword(OCIDBToolsConnection ocidbToolsConnection) {
        TextSecret secret = TextSecret.none();
        DatabaseToolsConnection dbToolsConn = ocidbToolsConnection.getDbtoolsConnection();
        if (dbToolsConn instanceof DatabaseToolsConnectionOracleDatabase) {
            String secretID;
            DatabaseToolsConnectionOracleDatabase oracleDatabase = (DatabaseToolsConnectionOracleDatabase)dbToolsConn;
            DatabaseToolsUserPassword dbToolsPwd = oracleDatabase.getUserPassword();
            String string = secretID = dbToolsPwd instanceof DatabaseToolsUserPasswordSecretId ? ((DatabaseToolsUserPasswordSecretId)dbToolsPwd).getSecretId() : null;
            if (secretID != null) {
                secret = this.getSecret(secretID);
            }
        }
        return secret;
    }

    private static String generatePassword() {
        Random random = new Random();
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int i = 0; i < 2; ++i) {
            chars.add(Character.valueOf('@'));
            chars.add(Character.valueOf('#'));
        }
        IntStream ints = random.ints(2L, 48, 57);
        ints.forEach(value -> chars.add(Character.valueOf((char)value)));
        IntStream upperAlphas = random.ints(8L, 65, 90);
        upperAlphas.forEach(value -> chars.add(Character.valueOf((char)value)));
        StringBuilder buff = new StringBuilder();
        IntStream lowerAlphas = random.ints(12L, 97, 122);
        lowerAlphas.forEach(value -> {
            if (buff.length() == 0) {
                buff.append((char)value);
            } else {
                chars.add(Character.valueOf((char)value));
            }
        });
        Collections.shuffle(chars, random);
        Iterator iterator = chars.iterator();
        while (iterator.hasNext()) {
            char ch = ((Character)iterator.next()).charValue();
            buff.append(ch);
        }
        return buff.toString();
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCIDatabaseClient> {
        private ProxyChecker proxy;
        private boolean useThick = false;
        private OCISecretsClient secretsClient;
        private OCIDatabaseServiceClient databaseClient;

        private Builder(AuthenticationProvider profile) {
            super(profile);
        }

        public Builder proxy(ProxyChecker proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder useThick(boolean useThick) {
            this.useThick = useThick;
            return this;
        }

        public Builder secretsClient(OCISecretsClient secretsClient) {
            this.secretsClient = secretsClient;
            return this;
        }

        public Builder databaseClient(OCIDatabaseServiceClient databaseClient) {
            this.databaseClient = databaseClient;
            return this;
        }

        @Override
        public OCIDatabaseClient build() {
            return new OCIDatabaseClient(this);
        }
    }
}

