/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.objectstorage.model.CreatePrivateEndpointDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePrivateEndpointRequest
extends BmcRequest<CreatePrivateEndpointDetails> {
    private String namespaceName;
    private CreatePrivateEndpointDetails createPrivateEndpointDetails;
    private String opcClientRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CreatePrivateEndpointDetails getCreatePrivateEndpointDetails() {
        return this.createPrivateEndpointDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    @InternalSdk
    public CreatePrivateEndpointDetails getBody$() {
        return this.createPrivateEndpointDetails;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).createPrivateEndpointDetails(this.createPrivateEndpointDetails).opcClientRequestId(this.opcClientRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",createPrivateEndpointDetails=").append(String.valueOf((Object)this.createPrivateEndpointDetails));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePrivateEndpointRequest)) {
            return false;
        }
        CreatePrivateEndpointRequest other = (CreatePrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.createPrivateEndpointDetails, (Object)other.createPrivateEndpointDetails) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.createPrivateEndpointDetails == null ? 43 : this.createPrivateEndpointDetails.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePrivateEndpointRequest, CreatePrivateEndpointDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private CreatePrivateEndpointDetails createPrivateEndpointDetails = null;
        private String opcClientRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder createPrivateEndpointDetails(CreatePrivateEndpointDetails createPrivateEndpointDetails) {
            this.createPrivateEndpointDetails = createPrivateEndpointDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePrivateEndpointRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.createPrivateEndpointDetails(o.getCreatePrivateEndpointDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePrivateEndpointRequest build() {
            CreatePrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePrivateEndpointDetails body) {
            this.createPrivateEndpointDetails(body);
            return this;
        }

        public CreatePrivateEndpointRequest buildWithoutInvocationCallback() {
            CreatePrivateEndpointRequest request = new CreatePrivateEndpointRequest();
            request.namespaceName = this.namespaceName;
            request.createPrivateEndpointDetails = this.createPrivateEndpointDetails;
            request.opcClientRequestId = this.opcClientRequestId;
            return request;
        }
    }
}

