/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum ChecksumAlgorithm implements BmcEnum
{
    Crc32C("CRC32C"),
    Sha256("SHA256"),
    Sha384("SHA384");

    private final String value;
    private static Map<String, ChecksumAlgorithm> map;

    private ChecksumAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static ChecksumAlgorithm create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid ChecksumAlgorithm: " + key);
    }

    static {
        map = new HashMap<String, ChecksumAlgorithm>();
        for (ChecksumAlgorithm v : ChecksumAlgorithm.values()) {
            map.put(v.getValue(), v);
        }
    }
}

