/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.jobs;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import oracle.dbtools.extension.jobs.JobsMessages;
import oracle.dbtools.extension.jobs.JobsStatus;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.command.CommandTask;
import oracle.dbtools.raptor.backgroundTask.jobs.JobCancelException;
import oracle.dbtools.raptor.backgroundTask.jobs.JobNotFoundException;
import oracle.dbtools.raptor.backgroundTask.jobs.JobsProcessor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.util.SqlId;

public class JobsUtil {
    private JobsUtil() {
    }

    public static JobsStatus getStatus() {
        int total = 0;
        int created = 0;
        int waiting = 0;
        int running = 0;
        int paused = 0;
        int finished = 0;
        int failed = 0;
        for (JobsProcessor.Job job : JobsProcessor.list()) {
            ++total;
            switch (job.getTask().getStatus()) {
                case NEW: {
                    ++created;
                    break;
                }
                case WAITING: {
                    ++waiting;
                    break;
                }
                case RUNNABLE: {
                    ++running;
                    break;
                }
                case PAUSED: {
                    ++paused;
                    break;
                }
                case FINISHED: {
                    ++finished;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
            }
        }
        return new JobsStatus(total, created, waiting, running, paused, finished, failed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void list(ScriptRunnerContext ctx, Integer id, String taskName) {
        List jobs = JobsProcessor.list();
        if (jobs.isEmpty()) {
            ctx.writeln(JobsMessages.getString("Jobs.NoJobs"));
            return;
        }
        if (!JobsUtil.details(ctx, id, taskName)) {
            int cnt = 0;
            List list = jobs;
            synchronized (list) {
                for (JobsProcessor.Job job : jobs) {
                    int logFileLength;
                    int taskStatusLength;
                    int taskIdLength;
                    int lineSize;
                    int taskNameMaxLength;
                    ++cnt;
                    RaptorTask task = job.getTask();
                    Object logFile = "";
                    if (job.getTask() instanceof CommandTask) {
                        logFile = "(" + ((CommandTask)job.getTask()).getLog().toString() + ")";
                    }
                    if ((taskNameMaxLength = (lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString())) - (taskIdLength = 4) - (taskStatusLength = 14) - (logFileLength = ((String)logFile).length())) < 5) {
                        taskNameMaxLength = 5;
                    }
                    if (taskNameMaxLength > task.getDescriptor().getName().length()) {
                        taskNameMaxLength = task.getDescriptor().getName().length();
                    }
                    String taskName2 = task.getDescriptor().getName().substring(0, taskNameMaxLength);
                    String line = String.format("%1$2d: [ %2$-8s ] %3$s %4$s", job.getId(), task.getStatus().value(), taskName2, logFile);
                    ctx.writeln(line);
                }
            }
            if (cnt == 0) {
                ctx.writeln(JobsMessages.getString("Jobs.NoJobs"));
            }
        }
    }

    private static boolean details(ScriptRunnerContext ctx, Integer id, String taskName) {
        if (id == null && (taskName == null || taskName.isEmpty())) {
            return false;
        }
        try {
            List<JobsProcessor.Job> foundJobs = JobsUtil.checkGetJobs(id, taskName);
            int foundJobsSize = foundJobs.size();
            int lastJobIndex = foundJobsSize - 1;
            for (int i = 0; i < foundJobsSize; ++i) {
                JobsUtil.printTaskDetails(ctx, foundJobs.get(i));
                if (i >= lastJobIndex) continue;
                JobsUtil.printSeparator(ctx);
            }
        }
        catch (JobNotFoundException e) {
            ctx.writeln(e.getMessage());
        }
        return true;
    }

    private static void printSeparator(ScriptRunnerContext ctx) {
        int terminalWidth = ctx.getSQLPlusConsoleReader().getWidth();
        ctx.writeln("-".repeat(terminalWidth / 2));
    }

    private static void printTaskDetails(ScriptRunnerContext ctx, JobsProcessor.Job job) {
        if (job == null) {
            return;
        }
        RaptorTask task = job.getTask();
        JobsUtil.printDetail(ctx, "Jobs.Details.Id", job.getId());
        JobsUtil.printDetail(ctx, "Jobs.Details.Name", task.getDescriptor().getName());
        JobsUtil.printDetail(ctx, "Jobs.Details.Status", task.getDescriptor().getStatus().value());
        JobsUtil.printDetail(ctx, "Jobs.Details.Message", task.getDescriptor().getMessage());
        JobsUtil.printDetail(ctx, "Jobs.Details.Throwable", task.getDescriptor().getThrowable());
        JobsUtil.printDetail(ctx, "Jobs.Details.StartedAt", JobsUtil.toDateTimeString(task.getDescriptor().getStartTime()));
        JobsUtil.printDetail(ctx, "Jobs.Details.Progress", task.getDescriptor().getProgress());
        JobsUtil.printDetail(ctx, "Jobs.Details.ProgressAt", JobsUtil.toDateTimeString(task.getDescriptor().getLastProgressTime()));
        JobsUtil.printDetail(ctx, "Jobs.Details.ElapsedTime", task.getDescriptor().getElapsedTime());
        JobsUtil.printDetail(ctx, "Jobs.Details.Waiting4", JobsUtil.getWaitingFor(task));
        if (task instanceof CommandTask) {
            Connection conn;
            CommandTask commandTask = (CommandTask)task;
            JobsUtil.printDetail(ctx, "Jobs.Details.Logfile", commandTask.getLog());
            ScriptRunnerContext tctx = commandTask.getCtx();
            if (tctx != null) {
                JobsUtil.printDetail(ctx, "Jobs.Details.Context", tctx.toString());
            }
            if ((conn = commandTask.getConn()) != null) {
                JobsUtil.printDetail(ctx, "Jobs.Details.Connection", conn.toString());
                String url = commandTask.getConnUrl();
                String user = commandTask.getConnUser();
                String role = ctx.getPrivilege(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString());
                JobsUtil.printDetail(ctx, "Jobs.Details.Connection", user + "@" + url + " " + role);
                String conid = ctx.getConnectionID(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString());
                if (conid != null && !conid.equals("")) {
                    JobsUtil.printDetail(ctx, "Jobs.Details.ConnectionIdentifier", conid);
                }
            }
            JobsUtil.printDetail(ctx, "Jobs.Details.Command", commandTask.getCmd());
            try {
                JobsUtil.printDetail(ctx, "Jobs.Details.Sqlid", SqlId.stmt2sqlid((String)commandTask.getCmd()));
            }
            catch (Exception url) {
                // empty catch block
            }
            ParsedCommand parsedCmd = commandTask.getParsedCmd();
            if (parsedCmd != null) {
                JobsUtil.printDetail(ctx, "Jobs.Details.ParsedCommand", parsedCmd);
            }
        }
        JobsUtil.printDetail(ctx, "Jobs.Details.InDeterminate", task.getDescriptor().isInDeterminate());
        JobsUtil.printDetail(ctx, "Jobs.Details.Cancellable", task.isCancellable());
        JobsUtil.printDetail(ctx, "Jobs.Details.Pausable", task.getRaptorTaskProgressUpdater().isPausable());
    }

    private static void printDetail(ScriptRunnerContext ctx, String msgKey, Object value) {
        ctx.writeln(String.format("%1$-18s: %2$s", JobsMessages.get(msgKey), value));
    }

    private static String toDateTimeString(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    private static String getWaitingFor(RaptorTask<?> task) {
        Object w4taskString = "";
        for (String w4task : task.getTasksToWait4()) {
            if (((String)w4taskString).length() > 0) {
                w4taskString = (String)w4taskString + ", ";
            }
            w4taskString = (String)w4taskString + w4task;
        }
        return w4taskString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JobsProcessor.Job> checkGetJobs(Integer id, String taskName) {
        AtomicReference foundJobs = new AtomicReference(new ArrayList());
        List jobs = JobsProcessor.list();
        if (id != null) {
            List list = jobs;
            synchronized (list) {
                for (JobsProcessor.Job job : jobs) {
                    if (job.getId() != id.intValue()) continue;
                    ((List)foundJobs.get()).add(job);
                    return foundJobs.get();
                }
                throw new JobNotFoundException(JobsMessages.format("Jobs.NoJobWithId", id));
            }
        }
        if (taskName != null && !taskName.isBlank()) {
            List list = jobs;
            synchronized (list) {
                for (JobsProcessor.Job job : jobs) {
                    if (!job.getTask().getDescriptor().getName().equals(taskName)) continue;
                    ((List)foundJobs.get()).add(job);
                }
                if (((List)foundJobs.get()).isEmpty()) {
                    throw new JobNotFoundException(JobsMessages.format("Jobs.NoJobWithName", taskName));
                }
            }
        }
        return foundJobs.get();
    }

    public static void cancel(ScriptRunnerContext ctx, Integer id, String taskName) {
        try {
            List<JobsProcessor.Job> foundJobs = JobsUtil.checkGetJobs(id, taskName);
            foundJobs.stream().map(JobsProcessor.Job::getTask).forEach(JobsProcessor::cancelTask);
            ctx.writeln(JobsMessages.getString("Jobs.Cancel.Request"));
        }
        catch (JobCancelException | JobNotFoundException e) {
            ctx.writeln(e.getMessage());
        }
    }

    public static void showLogs(ScriptRunnerContext ctx, Integer id, String taskName) {
        try {
            List<JobsProcessor.Job> foundJobs = JobsUtil.checkGetJobs(id, taskName);
            int foundJobsSize = foundJobs.size();
            int lastJobIndex = foundJobsSize - 1;
            for (int i = 0; i < foundJobsSize; ++i) {
                JobsUtil.showTaskLogs(ctx, foundJobs.get(i).getTask());
                if (i >= lastJobIndex) continue;
                JobsUtil.printSeparator(ctx);
            }
        }
        catch (JobNotFoundException e) {
            ctx.writeln(e.getMessage());
        }
    }

    private static void showTaskLogs(ScriptRunnerContext ctx, RaptorTask<?> task) {
        if (task != null && task instanceof CommandTask) {
            CommandTask commandTask = (CommandTask)task;
            try {
                commandTask.getCtx().getOutputStream().flush();
                Files.copy((File)commandTask.getLog(), (OutputStream)ctx.getOutputStream());
            }
            catch (IOException e) {
                ctx.writeln(JobsMessages.format("Jobs.Logs.ShowError", e.getMessage()));
            }
        }
    }

    public static void delete(ScriptRunnerContext ctx, Integer id, String taskName, boolean all, boolean finished) {
        if (!all && !finished && id == null && taskName == null) {
            ctx.writeln(JobsMessages.getString("Jobs.Delete.NoJobs"));
            return;
        }
        try {
            JobsUtil.checkGetJobs(id, taskName);
        }
        catch (JobNotFoundException e) {
            ctx.writeln(e.getMessage());
            return;
        }
        int count = JobsProcessor.delete(job -> all || finished && job.getTask().getStatus() == IRaptorTaskStatus.FINISHED || id != null && job.getId() == id.intValue() || job.getTask().getDescriptor().getName().equals(taskName));
        ctx.writeln(JobsMessages.format("Jobs.Delete.Deleted", count));
    }

    public static void deleteLogs(ScriptRunnerContext ctx) {
        try {
            JobsProcessor.deleteLogs();
            ctx.writeln(JobsMessages.format("Jobs.Logs.DeleteOk", CommandTask.getLogPath()));
        }
        catch (UncheckedIOException e) {
            ctx.writeln(JobsMessages.format("Jobs.Logs.DeleteError", e.getMessage()));
        }
    }
}

