/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rest;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.extension.rest.ORDSExportPackage;
import oracle.dbtools.extension.rest.ORDSItemType;
import oracle.dbtools.extension.rest.RestExportCall;
import oracle.dbtools.extension.rest.RestOptions;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.jdbc.OracleConnection;

public class RestExportSchemaCall
extends RestExportCall {
    ParsedCommand command;
    String schemaName;
    Boolean runnableAsAdmin;

    public RestExportSchemaCall(ParsedCommand command) {
        super(ORDSItemType.SCHEMA, "");
        this.command = command;
        this.setCommandOptions(command);
    }

    @Override
    public CallableStatement getCallableStatement(OracleConnection conn) throws SQLException {
        String plSqlCode = super.getPLSQL_CODE_BLOCK_CALL();
        if ("".equals(this.command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME))) {
            super.setOrdsItemName(conn.getCurrentSchema());
        } else {
            super.setOrdsItemName((String)this.command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME));
        }
        ORDSExportPackage ordsPackage = "".equals(this.schemaName) ? ORDSExportPackage.PUBLIC : ORDSExportPackage.ADMIN;
        plSqlCode = plSqlCode.replace(":ORDS_PACKAGE", ordsPackage.getString());
        plSqlCode = plSqlCode.replace(":PACKAGE_FUNCTION", "EXPORT_SCHEMA");
        plSqlCode = plSqlCode.replace(":PARAMETERS", this.constructParameters(ordsPackage));
        CallableStatement stmt = conn.prepareCall(plSqlCode);
        stmt.registerOutParameter(1, 2005);
        return stmt;
    }

    private String constructParameters(ORDSExportPackage exportPackage) {
        StringBuilder parameters = new StringBuilder();
        if (exportPackage == ORDSExportPackage.ADMIN) {
            parameters.append("p_schema => '").append(super.getOrdsItemName()).append("' , p_runnable_as_admin => ").append(this.runnableAsAdmin);
        } else {
            parameters.append("p_include_enable_schema => TRUE, p_include_privs => TRUE, p_include_oauth => TRUE");
        }
        return parameters.toString();
    }

    private void setCommandOptions(ParsedCommand command) {
        this.schemaName = (String)command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME);
        this.runnableAsAdmin = (Boolean)command.getOptionValue((Id)RestOptions.Symbol.RUNNABLE_AS_ADMIN);
    }
}

