/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rest;

import jakarta.json.stream.JsonParsingException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.rest.ORDSExportWrapper;
import oracle.dbtools.extension.rest.RESTExtractor;
import oracle.dbtools.extension.rest.RestExportClientCall;
import oracle.dbtools.extension.rest.RestExportModuleCall;
import oracle.dbtools.extension.rest.RestExportSchemaCall;
import oracle.dbtools.extension.rest.RestMessages;
import oracle.dbtools.extension.rest.RestOptions;
import oracle.dbtools.extension.rest.exceptions.ModuleNotFoundException;
import oracle.dbtools.extension.rest.exceptions.ModuleSearchOrigin;
import oracle.dbtools.extension.rest.exceptions.OrdsNotInstalledOrLackOfPrivilegesException;
import oracle.dbtools.extension.rest.exceptions.RestCallException;
import oracle.dbtools.extension.rest.exceptions.UnknownRestCallException;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.rest.export.RestExport;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.swagger.SwaggerImport;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OracleConnection;

public class RESTCommand
extends ParsedCommandListener
implements SQLCLService {
    private static final String ALL_PRIVS_QUERY = "select NAME, LABEL, DESCRIPTION, COMMENTS from USER_ORDS_PRIVILEGES where schema_id > 1000";
    private static final String SYS_SCHEMAS_QUERY = "select s.PARSING_SCHEMA, m.PATTERN, s.STATUS  from ORDS_METADATA.ORDS_SCHEMAS s, ORDS_METADATA.ORDS_URL_MAPPINGS m where s.url_mapping_id = m.id and S.PARSING_SCHEMA <> 'ORDS_METADATA'";
    private static final String ALL_SCHEMAS_QUERY = "select PARSING_SCHEMA, PATTERN, STATUS from USER_ORDS_SCHEMAS";
    private static final String ALL_MODULES_QUERY = "select NAME, URI_PREFIX PREFIX, STATUS, ITEMS_PER_PAGE from USER_ORDS_MODULES";
    private String ALL_MODULES_ADMIN_QUERY = "select s.parsing_schema AS schema , m.name, m.uri_prefix, m.status, m.items_per_page from dba_ords_modules m left join dba_ords_schemas s on m.schema_id = s.id\nwhere s.parsing_schema = ':SCHEMA'";
    private String ALL_PRIVS_ADMIN_QUERY = "select s.parsing_schema AS schema , p.name, p.label, p.description, p.comments from dba_ords_privileges p left join dba_ords_schemas s on p.schema_id = s.id\nwhere s.parsing_schema = ':SCHEMA'";
    private static final String ALL_CLIENTS_QUERY = "select NAME, DESCRIPTION from USER_ORDS_CLIENTS";
    private static final String ALL_CLIENTS_ADMIN_QUERY = "select s.parsing_schema AS \"-schema-name\", c.name, c.description from dba_ords_clients c left join dba_ords_schemas s on c.schema_id = s.id\nwhere s.parsing_schema = ':SCHEMA'";
    private static final String CMD = "REST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        try {
            Id _command = parsedCommand.getType().getId();
            if (null == conn) {
                ctx.writeln(RestMessages.get("Not_connected"));
                return true;
            }
            String generated = "";
            if (RestOptions.Symbol.SCHEMA == _command) {
                generated = this.handleExportSchema((OracleConnection)conn, parsedCommand);
                ctx.writeln(generated);
                return true;
            }
            if (RestOptions.Symbol.EXPORT == _command) {
                String moduleNameOrPrefix = (String)parsedCommand.getParameterValue((Id)RestOptions.Symbol.ITEM_NAME);
                generated = this.handleExportModule((OracleConnection)conn, moduleNameOrPrefix);
                ctx.writeln(generated);
                return true;
            }
            if (RestOptions.Symbol.IMPORT == _command) {
                String file = (String)parsedCommand.getParameterValue((Id)RestOptions.Symbol.JSON_FILE_PATH);
                this.handleImport(file, ctx);
                return true;
            }
            if (RestOptions.Symbol.MODULES == _command) {
                this.listAllModules(conn, ctx, parsedCommand);
                return true;
            }
            if (RestOptions.Symbol.PRIVILEGES == _command) {
                this.listAllPrivs(conn, ctx, parsedCommand);
                return true;
            }
            if (RestOptions.Symbol.SCHEMAS == _command) {
                this.listAllSchemas(conn, ctx);
                return true;
            }
            if (RestOptions.Symbol.MODULE == _command) {
                generated = this.handleExportModuleWithPackages((OracleConnection)conn, parsedCommand);
                ctx.writeln(generated);
                return true;
            }
            if (RestOptions.Symbol.CLIENTS == _command) {
                this.listAllClients(conn, ctx, parsedCommand);
                return true;
            }
            if (RestOptions.Symbol.CLIENT == _command) {
                generated = this.handleExportClient((OracleConnection)conn, parsedCommand);
                ctx.writeln(generated);
                return true;
            }
            ctx.write(this.getHelp(ctx, CMD).orElse("") + "\n");
            return true;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942) {
                ctx.writeln(RestMessages.getString("Ords_not_installed"));
                return true;
            }
            Logger.finest(((Object)((Object)this)).getClass(), (String)e.getLocalizedMessage(), (Throwable)e);
            ctx.writeln(RestMessages.format(RestMessages.getString("Other_Error"), e.getMessage()));
            return true;
        }
        catch (IllegalStateException e) {
            ctx.writeln(e.getMessage());
            return true;
        }
        catch (IOException f) {
            Logger.finest(((Object)((Object)this)).getClass(), (String)f.getLocalizedMessage(), (Throwable)f);
            return true;
        }
        catch (ModuleNotFoundException g) {
            ModuleSearchOrigin origin = g.getOrigin();
            if (origin.name().equals(ModuleSearchOrigin.ALL.name())) {
                ctx.writeln(RestMessages.getString("No_module_generic"));
                return true;
            }
            if (origin.name().equals(ModuleSearchOrigin.NAME.name())) {
                ctx.writeln(RestMessages.format("Module_named_error", g.getModuleName()));
                return true;
            }
            if (origin.name().equals(ModuleSearchOrigin.PATH.name())) {
                if ("/".equals(g.getModulePath())) {
                    ctx.writeln(RestMessages.getString("No_module_empty_prefix"));
                    return true;
                } else {
                    ctx.writeln(RestMessages.getString("No_module_found"));
                }
                return true;
            }
            ctx.writeln(RestMessages.getString("Unknown_module_origin"));
            return true;
        }
        catch (RestCallException e) {
            ctx.writeln(e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleImport(String filename, ScriptRunnerContext ctx) {
        String contents;
        block8: {
            if (filename == null) {
                ctx.writeln(RestMessages.getString("File_required"));
                return true;
            }
            contents = this.readFile(filename, ctx);
            if (contents != null) break block8;
            boolean bl = true;
            return bl;
        }
        try {
            SwaggerImport importer = new SwaggerImport();
            String result = importer.importSwagger(contents);
            ctx.writeln(result);
        }
        catch (IOException f) {
            Logger.finest(((Object)((Object)this)).getClass(), (String)f.getLocalizedMessage(), (Throwable)f);
            boolean bl = true;
            return bl;
        }
        catch (JsonParsingException e) {
            ctx.writeln(RestMessages.getString("Json_invalid"));
        }
        return true;
    }

    private String handleExportSchema(OracleConnection conn, ParsedCommand command) throws RestCallException {
        String generated = "";
        RestExportSchemaCall exportSchema = new RestExportSchemaCall(command);
        generated = ORDSExportWrapper.executeExport(exportSchema, conn);
        return generated;
    }

    private String handleExportModule(OracleConnection conn, String restItemName) throws SQLException, IOException, ModuleNotFoundException {
        RESTExtractor caller = new RESTExtractor();
        RESTExtractor.ExportEntity result = caller.getExport((Connection)conn, restItemName);
        String schemaName = "";
        String ordsVersion = "";
        if (result.schema != null) {
            schemaName = result.schema.getSchemaName();
            ordsVersion = result.schema.getOrdsSchemaVersion();
        }
        RestExport restExport = new RestExport("SQLcl", RestMessages.getString("SQLclVersion.VERSION"), schemaName, ordsVersion);
        RestSchema schema = result.schema;
        List<RestModule> modules = result.modules;
        ArrayList<RestPrivilege> privileges = new ArrayList<RestPrivilege>();
        ArrayList<String> rolesToCreate = new ArrayList<String>(result.rolesToCreate);
        privileges.addAll(result.privileges.values());
        String generated = restExport.exportModulesRolesPrivileges(schema, modules, rolesToCreate, privileges);
        return generated;
    }

    private String handleExportModuleWithPackages(OracleConnection conn, ParsedCommand command) throws RestCallException {
        String generated = "";
        RestExportModuleCall exportModule = new RestExportModuleCall(command);
        generated = ORDSExportWrapper.executeExport(exportModule, conn);
        return generated;
    }

    private String handleExportClient(OracleConnection conn, ParsedCommand command) throws RestCallException {
        String generated = "";
        RestExportClientCall exportClient = new RestExportClientCall(command);
        generated = ORDSExportWrapper.executeExport(exportClient, conn);
        return generated;
    }

    private String readFile(String fileName, ScriptRunnerContext ctx) throws IOException {
        Path file = Paths.get(fileName, new String[0]);
        boolean fileExists = Files.exists(file, new LinkOption[0]);
        if (!fileExists) {
            ctx.writeln(RestMessages.format("File_not_exists", fileName));
            return null;
        }
        List<String> readLines = Files.readAllLines(file);
        StringBuilder contents = new StringBuilder();
        for (String line : readLines) {
            contents.append(line);
        }
        return contents.toString();
    }

    private void listAllModules(Connection conn, ScriptRunnerContext ctx, ParsedCommand command) throws RestCallException, IOException {
        try {
            PreparedStatement stmt;
            OracleConnection ocon = (OracleConnection)conn;
            if ("".equals(command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME))) {
                stmt = ocon.prepareStatement(ALL_MODULES_QUERY);
            } else {
                String query = this.ALL_MODULES_ADMIN_QUERY.replace(":SCHEMA", (CharSequence)command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME)).toUpperCase();
                stmt = ocon.prepareStatement(query);
            }
            this.executeGenericCall(ctx, stmt);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942) {
                throw new OrdsNotInstalledOrLackOfPrivilegesException();
            }
            throw new UnknownRestCallException(e);
        }
    }

    private void listAllSchemas(Connection conn, ScriptRunnerContext ctx) throws RestCallException, IOException {
        block5: {
            OracleConnection ocon = (OracleConnection)conn;
            try {
                PreparedStatement stmt = ocon.prepareStatement(SYS_SCHEMAS_QUERY);
                this.executeGenericCall(ctx, stmt);
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 942) break block5;
                try {
                    PreparedStatement stmt = ocon.prepareStatement(ALL_SCHEMAS_QUERY);
                    this.executeGenericCall(ctx, stmt);
                }
                catch (SQLException ex) {
                    if (e.getErrorCode() == 942) {
                        throw new OrdsNotInstalledOrLackOfPrivilegesException();
                    }
                    throw new UnknownRestCallException(ex);
                }
            }
        }
    }

    private void listAllPrivs(Connection conn, ScriptRunnerContext ctx, ParsedCommand command) throws RestCallException, IOException {
        try {
            PreparedStatement stmt;
            OracleConnection ocon = (OracleConnection)conn;
            if ("".equals(command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME))) {
                stmt = ocon.prepareStatement(ALL_PRIVS_QUERY);
            } else {
                String query = this.ALL_PRIVS_ADMIN_QUERY.replace(":SCHEMA", (CharSequence)command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME)).toUpperCase();
                stmt = ocon.prepareStatement(query);
            }
            this.executeGenericCall(ctx, stmt);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942) {
                throw new OrdsNotInstalledOrLackOfPrivilegesException();
            }
            throw new UnknownRestCallException(e);
        }
    }

    private void listAllClients(Connection conn, ScriptRunnerContext ctx, ParsedCommand command) throws RestCallException, IOException {
        try {
            PreparedStatement stmt;
            OracleConnection ocon = (OracleConnection)conn;
            if ("".equals(command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME))) {
                stmt = ocon.prepareStatement(ALL_CLIENTS_QUERY);
            } else {
                String query = ALL_CLIENTS_ADMIN_QUERY.replace(":SCHEMA", (CharSequence)command.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME)).toUpperCase();
                stmt = ocon.prepareStatement(query);
            }
            this.executeGenericCall(ctx, stmt);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942) {
                throw new OrdsNotInstalledOrLackOfPrivilegesException();
            }
            throw new UnknownRestCallException(e);
        }
    }

    private void executeGenericCall(ScriptRunnerContext ctx, PreparedStatement statement) throws SQLException, IOException {
        ResultSet result = statement.executeQuery();
        SQLPLUSCmdFormatter formatter = new SQLPLUSCmdFormatter(ctx);
        formatter.rset2sqlplusShrinkToSize(result, ctx.getBaseConnection(), (BufferedOutputStream)ctx.getOutputStream());
    }

    protected boolean splitArgs(String commandline, ArrayList<String> args) {
        int lineLength = commandline.length();
        int terminalIndex = lineLength - 1;
        boolean nullChar = false;
        StringBuilder arg = new StringBuilder();
        StringBuilder quoted = new StringBuilder();
        char quoteChar = '\u0000';
        for (int i = 0; i < lineLength; ++i) {
            char ch = commandline.charAt(i);
            if (quoteChar != '\u0000') {
                quoted.append(ch);
                if (ch == quoteChar) {
                    arg.append((CharSequence)quoted);
                    quoted = new StringBuilder();
                    quoteChar = '\u0000';
                }
            } else if (ch == '\"' || ch == '\'') {
                quoted.append(ch);
                quoteChar = ch;
            } else if (Character.isWhitespace(ch)) {
                if (arg.length() > 0) {
                    args.add(arg.toString());
                    arg = new StringBuilder();
                }
            } else {
                arg.append(ch);
            }
            if (i != terminalIndex || quoteChar == '\u0000') continue;
            arg.append(quoteChar);
            i -= quoted.length() - 1;
            quoted = new StringBuilder();
            quoteChar = '\u0000';
        }
        if (arg.length() > 0) {
            args.add(arg.toString());
        }
        return true;
    }

    protected Type createType() {
        return RestOptions.commandType;
    }

    public String getCommand() {
        return CMD.toUpperCase();
    }

    public String getDescription() {
        return RestMessages.getString("Rest_Description");
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return RestMessages.getString("Rest_Description");
    }

    public String getExtensionName() {
        return RestMessages.getString("Extension_Name");
    }

    public String getExtensionVersion() {
        return RestMessages.getString("SQLclVersion.VERSION");
    }
}

