/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.core.model.InstanceMaintenanceEvent;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListInstanceMaintenanceEventsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String instanceId;
    private InstanceMaintenanceEvent.LifecycleState lifecycleState;
    private String correlationToken;
    private String instanceAction;
    private Date timeWindowStartGreaterThanOrEqualTo;
    private Date timeWindowStartLessThanOrEqualTo;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public InstanceMaintenanceEvent.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getCorrelationToken() {
        return this.correlationToken;
    }

    public String getInstanceAction() {
        return this.instanceAction;
    }

    public Date getTimeWindowStartGreaterThanOrEqualTo() {
        return this.timeWindowStartGreaterThanOrEqualTo;
    }

    public Date getTimeWindowStartLessThanOrEqualTo() {
        return this.timeWindowStartLessThanOrEqualTo;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).instanceId(this.instanceId).lifecycleState(this.lifecycleState).correlationToken(this.correlationToken).instanceAction(this.instanceAction).timeWindowStartGreaterThanOrEqualTo(this.timeWindowStartGreaterThanOrEqualTo).timeWindowStartLessThanOrEqualTo(this.timeWindowStartLessThanOrEqualTo).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",correlationToken=").append(String.valueOf(this.correlationToken));
        sb.append(",instanceAction=").append(String.valueOf(this.instanceAction));
        sb.append(",timeWindowStartGreaterThanOrEqualTo=").append(String.valueOf(this.timeWindowStartGreaterThanOrEqualTo));
        sb.append(",timeWindowStartLessThanOrEqualTo=").append(String.valueOf(this.timeWindowStartLessThanOrEqualTo));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListInstanceMaintenanceEventsRequest)) {
            return false;
        }
        ListInstanceMaintenanceEventsRequest other = (ListInstanceMaintenanceEventsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.correlationToken, other.correlationToken) && Objects.equals(this.instanceAction, other.instanceAction) && Objects.equals(this.timeWindowStartGreaterThanOrEqualTo, other.timeWindowStartGreaterThanOrEqualTo) && Objects.equals(this.timeWindowStartLessThanOrEqualTo, other.timeWindowStartLessThanOrEqualTo) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.correlationToken == null ? 43 : this.correlationToken.hashCode());
        result = result * 59 + (this.instanceAction == null ? 43 : this.instanceAction.hashCode());
        result = result * 59 + (this.timeWindowStartGreaterThanOrEqualTo == null ? 43 : this.timeWindowStartGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeWindowStartLessThanOrEqualTo == null ? 43 : this.timeWindowStartLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListInstanceMaintenanceEventsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String instanceId = null;
        private InstanceMaintenanceEvent.LifecycleState lifecycleState = null;
        private String correlationToken = null;
        private String instanceAction = null;
        private Date timeWindowStartGreaterThanOrEqualTo = null;
        private Date timeWindowStartLessThanOrEqualTo = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder lifecycleState(InstanceMaintenanceEvent.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder correlationToken(String correlationToken) {
            this.correlationToken = correlationToken;
            return this;
        }

        public Builder instanceAction(String instanceAction) {
            this.instanceAction = instanceAction;
            return this;
        }

        public Builder timeWindowStartGreaterThanOrEqualTo(Date timeWindowStartGreaterThanOrEqualTo) {
            this.timeWindowStartGreaterThanOrEqualTo = timeWindowStartGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeWindowStartLessThanOrEqualTo(Date timeWindowStartLessThanOrEqualTo) {
            this.timeWindowStartLessThanOrEqualTo = timeWindowStartLessThanOrEqualTo;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListInstanceMaintenanceEventsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.instanceId(o.getInstanceId());
            this.lifecycleState(o.getLifecycleState());
            this.correlationToken(o.getCorrelationToken());
            this.instanceAction(o.getInstanceAction());
            this.timeWindowStartGreaterThanOrEqualTo(o.getTimeWindowStartGreaterThanOrEqualTo());
            this.timeWindowStartLessThanOrEqualTo(o.getTimeWindowStartLessThanOrEqualTo());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListInstanceMaintenanceEventsRequest build() {
            ListInstanceMaintenanceEventsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListInstanceMaintenanceEventsRequest buildWithoutInvocationCallback() {
            ListInstanceMaintenanceEventsRequest request = new ListInstanceMaintenanceEventsRequest();
            request.compartmentId = this.compartmentId;
            request.instanceId = this.instanceId;
            request.lifecycleState = this.lifecycleState;
            request.correlationToken = this.correlationToken;
            request.instanceAction = this.instanceAction;
            request.timeWindowStartGreaterThanOrEqualTo = this.timeWindowStartGreaterThanOrEqualTo;
            request.timeWindowStartLessThanOrEqualTo = this.timeWindowStartLessThanOrEqualTo;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

