/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetComputeHostRequest
extends BmcRequest<Void> {
    private String computeHostId;
    private String opcRequestId;

    public String getComputeHostId() {
        return this.computeHostId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().computeHostId(this.computeHostId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",computeHostId=").append(String.valueOf(this.computeHostId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetComputeHostRequest)) {
            return false;
        }
        GetComputeHostRequest other = (GetComputeHostRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.computeHostId, other.computeHostId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.computeHostId == null ? 43 : this.computeHostId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetComputeHostRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String computeHostId = null;
        private String opcRequestId = null;

        public Builder computeHostId(String computeHostId) {
            this.computeHostId = computeHostId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetComputeHostRequest o) {
            this.computeHostId(o.getComputeHostId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetComputeHostRequest build() {
            GetComputeHostRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetComputeHostRequest buildWithoutInvocationCallback() {
            GetComputeHostRequest request = new GetComputeHostRequest();
            request.computeHostId = this.computeHostId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

