/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetAllDrgAttachmentsRequest
extends BmcRequest<Void> {
    private String drgId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private AttachmentType attachmentType;
    private Boolean isCrossTenancy;

    public String getDrgId() {
        return this.drgId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public AttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public Boolean getIsCrossTenancy() {
        return this.isCrossTenancy;
    }

    public Builder toBuilder() {
        return new Builder().drgId(this.drgId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).attachmentType(this.attachmentType).isCrossTenancy(this.isCrossTenancy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgId=").append(String.valueOf(this.drgId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",attachmentType=").append(String.valueOf((Object)this.attachmentType));
        sb.append(",isCrossTenancy=").append(String.valueOf(this.isCrossTenancy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAllDrgAttachmentsRequest)) {
            return false;
        }
        GetAllDrgAttachmentsRequest other = (GetAllDrgAttachmentsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgId, other.drgId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.attachmentType, (Object)other.attachmentType) && Objects.equals(this.isCrossTenancy, other.isCrossTenancy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgId == null ? 43 : this.drgId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.attachmentType == null ? 43 : this.attachmentType.hashCode());
        result = result * 59 + (this.isCrossTenancy == null ? 43 : this.isCrossTenancy.hashCode());
        return result;
    }

    public static enum AttachmentType implements BmcEnum
    {
        Vcn("VCN"),
        VirtualCircuit("VIRTUAL_CIRCUIT"),
        RemotePeeringConnection("REMOTE_PEERING_CONNECTION"),
        IpsecTunnel("IPSEC_TUNNEL"),
        All("ALL");

        private final String value;
        private static Map<String, AttachmentType> map;

        private AttachmentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttachmentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AttachmentType: " + key);
        }

        static {
            map = new HashMap<String, AttachmentType>();
            for (AttachmentType v : AttachmentType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<GetAllDrgAttachmentsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private AttachmentType attachmentType = null;
        private Boolean isCrossTenancy = null;

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder attachmentType(AttachmentType attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        public Builder isCrossTenancy(Boolean isCrossTenancy) {
            this.isCrossTenancy = isCrossTenancy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAllDrgAttachmentsRequest o) {
            this.drgId(o.getDrgId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.attachmentType(o.getAttachmentType());
            this.isCrossTenancy(o.getIsCrossTenancy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAllDrgAttachmentsRequest build() {
            GetAllDrgAttachmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAllDrgAttachmentsRequest buildWithoutInvocationCallback() {
            GetAllDrgAttachmentsRequest request = new GetAllDrgAttachmentsRequest();
            request.drgId = this.drgId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.attachmentType = this.attachmentType;
            request.isCrossTenancy = this.isCrossTenancy;
            return request;
        }
    }
}

