/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InventoryVcnSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IpInventoryCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="count")
    private final Integer count;
    @JsonProperty(value="lastUpdatedTimestamp")
    private final Date lastUpdatedTimestamp;
    @JsonProperty(value="compartmentsPerTenant")
    private final Long compartmentsPerTenant;
    @JsonProperty(value="inventoryVcnCollection")
    private final List<InventoryVcnSummary> inventoryVcnCollection;
    @JsonProperty(value="message")
    private final String message;

    @Deprecated
    @ConstructorProperties(value={"count", "lastUpdatedTimestamp", "compartmentsPerTenant", "inventoryVcnCollection", "message"})
    public IpInventoryCollection(Integer count, Date lastUpdatedTimestamp, Long compartmentsPerTenant, List<InventoryVcnSummary> inventoryVcnCollection, String message) {
        this.count = count;
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        this.compartmentsPerTenant = compartmentsPerTenant;
        this.inventoryVcnCollection = inventoryVcnCollection;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getCount() {
        return this.count;
    }

    public Date getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Long getCompartmentsPerTenant() {
        return this.compartmentsPerTenant;
    }

    public List<InventoryVcnSummary> getInventoryVcnCollection() {
        return this.inventoryVcnCollection;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IpInventoryCollection(");
        sb.append("super=").append(super.toString());
        sb.append("count=").append(String.valueOf(this.count));
        sb.append(", lastUpdatedTimestamp=").append(String.valueOf(this.lastUpdatedTimestamp));
        sb.append(", compartmentsPerTenant=").append(String.valueOf(this.compartmentsPerTenant));
        sb.append(", inventoryVcnCollection=").append(String.valueOf(this.inventoryVcnCollection));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpInventoryCollection)) {
            return false;
        }
        IpInventoryCollection other = (IpInventoryCollection)((Object)o);
        return Objects.equals(this.count, other.count) && Objects.equals(this.lastUpdatedTimestamp, other.lastUpdatedTimestamp) && Objects.equals(this.compartmentsPerTenant, other.compartmentsPerTenant) && Objects.equals(this.inventoryVcnCollection, other.inventoryVcnCollection) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.lastUpdatedTimestamp == null ? 43 : this.lastUpdatedTimestamp.hashCode());
        result = result * 59 + (this.compartmentsPerTenant == null ? 43 : this.compartmentsPerTenant.hashCode());
        result = result * 59 + (this.inventoryVcnCollection == null ? 43 : this.inventoryVcnCollection.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="count")
        private Integer count;
        @JsonProperty(value="lastUpdatedTimestamp")
        private Date lastUpdatedTimestamp;
        @JsonProperty(value="compartmentsPerTenant")
        private Long compartmentsPerTenant;
        @JsonProperty(value="inventoryVcnCollection")
        private List<InventoryVcnSummary> inventoryVcnCollection;
        @JsonProperty(value="message")
        private String message;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder lastUpdatedTimestamp(Date lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            this.__explicitlySet__.add("lastUpdatedTimestamp");
            return this;
        }

        public Builder compartmentsPerTenant(Long compartmentsPerTenant) {
            this.compartmentsPerTenant = compartmentsPerTenant;
            this.__explicitlySet__.add("compartmentsPerTenant");
            return this;
        }

        public Builder inventoryVcnCollection(List<InventoryVcnSummary> inventoryVcnCollection) {
            this.inventoryVcnCollection = inventoryVcnCollection;
            this.__explicitlySet__.add("inventoryVcnCollection");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public IpInventoryCollection build() {
            IpInventoryCollection model = new IpInventoryCollection(this.count, this.lastUpdatedTimestamp, this.compartmentsPerTenant, this.inventoryVcnCollection, this.message);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IpInventoryCollection model) {
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("lastUpdatedTimestamp")) {
                this.lastUpdatedTimestamp(model.getLastUpdatedTimestamp());
            }
            if (model.wasPropertyExplicitlySet("compartmentsPerTenant")) {
                this.compartmentsPerTenant(model.getCompartmentsPerTenant());
            }
            if (model.wasPropertyExplicitlySet("inventoryVcnCollection")) {
                this.inventoryVcnCollection(model.getInventoryVcnCollection());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            return this;
        }
    }
}

