/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InventoryResourceSummary;
import com.oracle.bmc.core.model.InventorySubnetCidrBlockSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InventorySubnetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="subnetName")
    private final String subnetName;
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;
    @JsonProperty(value="inventorySubnetCidrCollection")
    private final List<InventorySubnetCidrBlockSummary> inventorySubnetCidrCollection;
    @JsonProperty(value="dnsDomainName")
    private final String dnsDomainName;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="inventoryResourceSummary")
    private final List<InventoryResourceSummary> inventoryResourceSummary;

    @Deprecated
    @ConstructorProperties(value={"subnetId", "subnetName", "resourceType", "inventorySubnetCidrCollection", "dnsDomainName", "region", "compartmentId", "inventoryResourceSummary"})
    public InventorySubnetSummary(String subnetId, String subnetName, ResourceType resourceType, List<InventorySubnetCidrBlockSummary> inventorySubnetCidrCollection, String dnsDomainName, String region, String compartmentId, List<InventoryResourceSummary> inventoryResourceSummary) {
        this.subnetId = subnetId;
        this.subnetName = subnetName;
        this.resourceType = resourceType;
        this.inventorySubnetCidrCollection = inventorySubnetCidrCollection;
        this.dnsDomainName = dnsDomainName;
        this.region = region;
        this.compartmentId = compartmentId;
        this.inventoryResourceSummary = inventoryResourceSummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getSubnetName() {
        return this.subnetName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public List<InventorySubnetCidrBlockSummary> getInventorySubnetCidrCollection() {
        return this.inventorySubnetCidrCollection;
    }

    public String getDnsDomainName() {
        return this.dnsDomainName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<InventoryResourceSummary> getInventoryResourceSummary() {
        return this.inventoryResourceSummary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InventorySubnetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", subnetName=").append(String.valueOf(this.subnetName));
        sb.append(", resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", inventorySubnetCidrCollection=").append(String.valueOf(this.inventorySubnetCidrCollection));
        sb.append(", dnsDomainName=").append(String.valueOf(this.dnsDomainName));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", inventoryResourceSummary=").append(String.valueOf(this.inventoryResourceSummary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InventorySubnetSummary)) {
            return false;
        }
        InventorySubnetSummary other = (InventorySubnetSummary)((Object)o);
        return Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.subnetName, other.subnetName) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.inventorySubnetCidrCollection, other.inventorySubnetCidrCollection) && Objects.equals(this.dnsDomainName, other.dnsDomainName) && Objects.equals(this.region, other.region) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.inventoryResourceSummary, other.inventoryResourceSummary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.subnetName == null ? 43 : this.subnetName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.inventorySubnetCidrCollection == null ? 43 : this.inventorySubnetCidrCollection.hashCode());
        result = result * 59 + (this.dnsDomainName == null ? 43 : this.dnsDomainName.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.inventoryResourceSummary == null ? 43 : this.inventoryResourceSummary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceType implements BmcEnum
    {
        Subnet("Subnet"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="subnetName")
        private String subnetName;
        @JsonProperty(value="resourceType")
        private ResourceType resourceType;
        @JsonProperty(value="inventorySubnetCidrCollection")
        private List<InventorySubnetCidrBlockSummary> inventorySubnetCidrCollection;
        @JsonProperty(value="dnsDomainName")
        private String dnsDomainName;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="inventoryResourceSummary")
        private List<InventoryResourceSummary> inventoryResourceSummary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder subnetName(String subnetName) {
            this.subnetName = subnetName;
            this.__explicitlySet__.add("subnetName");
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder inventorySubnetCidrCollection(List<InventorySubnetCidrBlockSummary> inventorySubnetCidrCollection) {
            this.inventorySubnetCidrCollection = inventorySubnetCidrCollection;
            this.__explicitlySet__.add("inventorySubnetCidrCollection");
            return this;
        }

        public Builder dnsDomainName(String dnsDomainName) {
            this.dnsDomainName = dnsDomainName;
            this.__explicitlySet__.add("dnsDomainName");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder inventoryResourceSummary(List<InventoryResourceSummary> inventoryResourceSummary) {
            this.inventoryResourceSummary = inventoryResourceSummary;
            this.__explicitlySet__.add("inventoryResourceSummary");
            return this;
        }

        public InventorySubnetSummary build() {
            InventorySubnetSummary model = new InventorySubnetSummary(this.subnetId, this.subnetName, this.resourceType, this.inventorySubnetCidrCollection, this.dnsDomainName, this.region, this.compartmentId, this.inventoryResourceSummary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InventorySubnetSummary model) {
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("subnetName")) {
                this.subnetName(model.getSubnetName());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("inventorySubnetCidrCollection")) {
                this.inventorySubnetCidrCollection(model.getInventorySubnetCidrCollection());
            }
            if (model.wasPropertyExplicitlySet("dnsDomainName")) {
                this.dnsDomainName(model.getDnsDomainName());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("inventoryResourceSummary")) {
                this.inventoryResourceSummary(model.getInventoryResourceSummary());
            }
            return this;
        }
    }
}

