/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FastConnectProviderService
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="privatePeeringBgpManagement")
    private final PrivatePeeringBgpManagement privatePeeringBgpManagement;
    @JsonProperty(value="providerName")
    private final String providerName;
    @JsonProperty(value="providerServiceName")
    private final String providerServiceName;
    @JsonProperty(value="publicPeeringBgpManagement")
    private final PublicPeeringBgpManagement publicPeeringBgpManagement;
    @JsonProperty(value="supportedVirtualCircuitTypes")
    private final List<SupportedVirtualCircuitTypes> supportedVirtualCircuitTypes;
    @JsonProperty(value="customerAsnManagement")
    private final CustomerAsnManagement customerAsnManagement;
    @JsonProperty(value="providerServiceKeyManagement")
    private final ProviderServiceKeyManagement providerServiceKeyManagement;
    @JsonProperty(value="bandwithShapeManagement")
    private final BandwithShapeManagement bandwithShapeManagement;
    @JsonProperty(value="requiredTotalCrossConnects")
    private final Integer requiredTotalCrossConnects;
    @JsonProperty(value="type")
    private final Type type;

    @Deprecated
    @ConstructorProperties(value={"description", "id", "privatePeeringBgpManagement", "providerName", "providerServiceName", "publicPeeringBgpManagement", "supportedVirtualCircuitTypes", "customerAsnManagement", "providerServiceKeyManagement", "bandwithShapeManagement", "requiredTotalCrossConnects", "type"})
    public FastConnectProviderService(String description, String id, PrivatePeeringBgpManagement privatePeeringBgpManagement, String providerName, String providerServiceName, PublicPeeringBgpManagement publicPeeringBgpManagement, List<SupportedVirtualCircuitTypes> supportedVirtualCircuitTypes, CustomerAsnManagement customerAsnManagement, ProviderServiceKeyManagement providerServiceKeyManagement, BandwithShapeManagement bandwithShapeManagement, Integer requiredTotalCrossConnects, Type type) {
        this.description = description;
        this.id = id;
        this.privatePeeringBgpManagement = privatePeeringBgpManagement;
        this.providerName = providerName;
        this.providerServiceName = providerServiceName;
        this.publicPeeringBgpManagement = publicPeeringBgpManagement;
        this.supportedVirtualCircuitTypes = supportedVirtualCircuitTypes;
        this.customerAsnManagement = customerAsnManagement;
        this.providerServiceKeyManagement = providerServiceKeyManagement;
        this.bandwithShapeManagement = bandwithShapeManagement;
        this.requiredTotalCrossConnects = requiredTotalCrossConnects;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public PrivatePeeringBgpManagement getPrivatePeeringBgpManagement() {
        return this.privatePeeringBgpManagement;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderServiceName() {
        return this.providerServiceName;
    }

    public PublicPeeringBgpManagement getPublicPeeringBgpManagement() {
        return this.publicPeeringBgpManagement;
    }

    public List<SupportedVirtualCircuitTypes> getSupportedVirtualCircuitTypes() {
        return this.supportedVirtualCircuitTypes;
    }

    public CustomerAsnManagement getCustomerAsnManagement() {
        return this.customerAsnManagement;
    }

    public ProviderServiceKeyManagement getProviderServiceKeyManagement() {
        return this.providerServiceKeyManagement;
    }

    public BandwithShapeManagement getBandwithShapeManagement() {
        return this.bandwithShapeManagement;
    }

    public Integer getRequiredTotalCrossConnects() {
        return this.requiredTotalCrossConnects;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FastConnectProviderService(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", privatePeeringBgpManagement=").append(String.valueOf((Object)this.privatePeeringBgpManagement));
        sb.append(", providerName=").append(String.valueOf(this.providerName));
        sb.append(", providerServiceName=").append(String.valueOf(this.providerServiceName));
        sb.append(", publicPeeringBgpManagement=").append(String.valueOf((Object)this.publicPeeringBgpManagement));
        sb.append(", supportedVirtualCircuitTypes=").append(String.valueOf(this.supportedVirtualCircuitTypes));
        sb.append(", customerAsnManagement=").append(String.valueOf((Object)this.customerAsnManagement));
        sb.append(", providerServiceKeyManagement=").append(String.valueOf((Object)this.providerServiceKeyManagement));
        sb.append(", bandwithShapeManagement=").append(String.valueOf((Object)this.bandwithShapeManagement));
        sb.append(", requiredTotalCrossConnects=").append(String.valueOf(this.requiredTotalCrossConnects));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastConnectProviderService)) {
            return false;
        }
        FastConnectProviderService other = (FastConnectProviderService)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.privatePeeringBgpManagement, (Object)other.privatePeeringBgpManagement) && Objects.equals(this.providerName, other.providerName) && Objects.equals(this.providerServiceName, other.providerServiceName) && Objects.equals((Object)this.publicPeeringBgpManagement, (Object)other.publicPeeringBgpManagement) && Objects.equals(this.supportedVirtualCircuitTypes, other.supportedVirtualCircuitTypes) && Objects.equals((Object)this.customerAsnManagement, (Object)other.customerAsnManagement) && Objects.equals((Object)this.providerServiceKeyManagement, (Object)other.providerServiceKeyManagement) && Objects.equals((Object)this.bandwithShapeManagement, (Object)other.bandwithShapeManagement) && Objects.equals(this.requiredTotalCrossConnects, other.requiredTotalCrossConnects) && Objects.equals((Object)this.type, (Object)other.type) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.privatePeeringBgpManagement == null ? 43 : this.privatePeeringBgpManagement.hashCode());
        result = result * 59 + (this.providerName == null ? 43 : this.providerName.hashCode());
        result = result * 59 + (this.providerServiceName == null ? 43 : this.providerServiceName.hashCode());
        result = result * 59 + (this.publicPeeringBgpManagement == null ? 43 : this.publicPeeringBgpManagement.hashCode());
        result = result * 59 + (this.supportedVirtualCircuitTypes == null ? 43 : this.supportedVirtualCircuitTypes.hashCode());
        result = result * 59 + (this.customerAsnManagement == null ? 43 : this.customerAsnManagement.hashCode());
        result = result * 59 + (this.providerServiceKeyManagement == null ? 43 : this.providerServiceKeyManagement.hashCode());
        result = result * 59 + (this.bandwithShapeManagement == null ? 43 : this.bandwithShapeManagement.hashCode());
        result = result * 59 + (this.requiredTotalCrossConnects == null ? 43 : this.requiredTotalCrossConnects.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PrivatePeeringBgpManagement implements BmcEnum
    {
        CustomerManaged("CUSTOMER_MANAGED"),
        ProviderManaged("PROVIDER_MANAGED"),
        OracleManaged("ORACLE_MANAGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PrivatePeeringBgpManagement> map;

        private PrivatePeeringBgpManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PrivatePeeringBgpManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PrivatePeeringBgpManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PrivatePeeringBgpManagement.class);
            map = new HashMap<String, PrivatePeeringBgpManagement>();
            for (PrivatePeeringBgpManagement v : PrivatePeeringBgpManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PublicPeeringBgpManagement implements BmcEnum
    {
        CustomerManaged("CUSTOMER_MANAGED"),
        ProviderManaged("PROVIDER_MANAGED"),
        OracleManaged("ORACLE_MANAGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PublicPeeringBgpManagement> map;

        private PublicPeeringBgpManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PublicPeeringBgpManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PublicPeeringBgpManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PublicPeeringBgpManagement.class);
            map = new HashMap<String, PublicPeeringBgpManagement>();
            for (PublicPeeringBgpManagement v : PublicPeeringBgpManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum CustomerAsnManagement implements BmcEnum
    {
        CustomerManaged("CUSTOMER_MANAGED"),
        ProviderManaged("PROVIDER_MANAGED"),
        OracleManaged("ORACLE_MANAGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CustomerAsnManagement> map;

        private CustomerAsnManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CustomerAsnManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CustomerAsnManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CustomerAsnManagement.class);
            map = new HashMap<String, CustomerAsnManagement>();
            for (CustomerAsnManagement v : CustomerAsnManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProviderServiceKeyManagement implements BmcEnum
    {
        CustomerManaged("CUSTOMER_MANAGED"),
        ProviderManaged("PROVIDER_MANAGED"),
        OracleManaged("ORACLE_MANAGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProviderServiceKeyManagement> map;

        private ProviderServiceKeyManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProviderServiceKeyManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProviderServiceKeyManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProviderServiceKeyManagement.class);
            map = new HashMap<String, ProviderServiceKeyManagement>();
            for (ProviderServiceKeyManagement v : ProviderServiceKeyManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BandwithShapeManagement implements BmcEnum
    {
        CustomerManaged("CUSTOMER_MANAGED"),
        ProviderManaged("PROVIDER_MANAGED"),
        OracleManaged("ORACLE_MANAGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BandwithShapeManagement> map;

        private BandwithShapeManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BandwithShapeManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BandwithShapeManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BandwithShapeManagement.class);
            map = new HashMap<String, BandwithShapeManagement>();
            for (BandwithShapeManagement v : BandwithShapeManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Layer2("LAYER2"),
        Layer3("LAYER3"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="privatePeeringBgpManagement")
        private PrivatePeeringBgpManagement privatePeeringBgpManagement;
        @JsonProperty(value="providerName")
        private String providerName;
        @JsonProperty(value="providerServiceName")
        private String providerServiceName;
        @JsonProperty(value="publicPeeringBgpManagement")
        private PublicPeeringBgpManagement publicPeeringBgpManagement;
        @JsonProperty(value="supportedVirtualCircuitTypes")
        private List<SupportedVirtualCircuitTypes> supportedVirtualCircuitTypes;
        @JsonProperty(value="customerAsnManagement")
        private CustomerAsnManagement customerAsnManagement;
        @JsonProperty(value="providerServiceKeyManagement")
        private ProviderServiceKeyManagement providerServiceKeyManagement;
        @JsonProperty(value="bandwithShapeManagement")
        private BandwithShapeManagement bandwithShapeManagement;
        @JsonProperty(value="requiredTotalCrossConnects")
        private Integer requiredTotalCrossConnects;
        @JsonProperty(value="type")
        private Type type;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder privatePeeringBgpManagement(PrivatePeeringBgpManagement privatePeeringBgpManagement) {
            this.privatePeeringBgpManagement = privatePeeringBgpManagement;
            this.__explicitlySet__.add("privatePeeringBgpManagement");
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            this.__explicitlySet__.add("providerName");
            return this;
        }

        public Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            this.__explicitlySet__.add("providerServiceName");
            return this;
        }

        public Builder publicPeeringBgpManagement(PublicPeeringBgpManagement publicPeeringBgpManagement) {
            this.publicPeeringBgpManagement = publicPeeringBgpManagement;
            this.__explicitlySet__.add("publicPeeringBgpManagement");
            return this;
        }

        public Builder supportedVirtualCircuitTypes(List<SupportedVirtualCircuitTypes> supportedVirtualCircuitTypes) {
            this.supportedVirtualCircuitTypes = supportedVirtualCircuitTypes;
            this.__explicitlySet__.add("supportedVirtualCircuitTypes");
            return this;
        }

        public Builder customerAsnManagement(CustomerAsnManagement customerAsnManagement) {
            this.customerAsnManagement = customerAsnManagement;
            this.__explicitlySet__.add("customerAsnManagement");
            return this;
        }

        public Builder providerServiceKeyManagement(ProviderServiceKeyManagement providerServiceKeyManagement) {
            this.providerServiceKeyManagement = providerServiceKeyManagement;
            this.__explicitlySet__.add("providerServiceKeyManagement");
            return this;
        }

        public Builder bandwithShapeManagement(BandwithShapeManagement bandwithShapeManagement) {
            this.bandwithShapeManagement = bandwithShapeManagement;
            this.__explicitlySet__.add("bandwithShapeManagement");
            return this;
        }

        public Builder requiredTotalCrossConnects(Integer requiredTotalCrossConnects) {
            this.requiredTotalCrossConnects = requiredTotalCrossConnects;
            this.__explicitlySet__.add("requiredTotalCrossConnects");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public FastConnectProviderService build() {
            FastConnectProviderService model = new FastConnectProviderService(this.description, this.id, this.privatePeeringBgpManagement, this.providerName, this.providerServiceName, this.publicPeeringBgpManagement, this.supportedVirtualCircuitTypes, this.customerAsnManagement, this.providerServiceKeyManagement, this.bandwithShapeManagement, this.requiredTotalCrossConnects, this.type);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FastConnectProviderService model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("privatePeeringBgpManagement")) {
                this.privatePeeringBgpManagement(model.getPrivatePeeringBgpManagement());
            }
            if (model.wasPropertyExplicitlySet("providerName")) {
                this.providerName(model.getProviderName());
            }
            if (model.wasPropertyExplicitlySet("providerServiceName")) {
                this.providerServiceName(model.getProviderServiceName());
            }
            if (model.wasPropertyExplicitlySet("publicPeeringBgpManagement")) {
                this.publicPeeringBgpManagement(model.getPublicPeeringBgpManagement());
            }
            if (model.wasPropertyExplicitlySet("supportedVirtualCircuitTypes")) {
                this.supportedVirtualCircuitTypes(model.getSupportedVirtualCircuitTypes());
            }
            if (model.wasPropertyExplicitlySet("customerAsnManagement")) {
                this.customerAsnManagement(model.getCustomerAsnManagement());
            }
            if (model.wasPropertyExplicitlySet("providerServiceKeyManagement")) {
                this.providerServiceKeyManagement(model.getProviderServiceKeyManagement());
            }
            if (model.wasPropertyExplicitlySet("bandwithShapeManagement")) {
                this.bandwithShapeManagement(model.getBandwithShapeManagement());
            }
            if (model.wasPropertyExplicitlySet("requiredTotalCrossConnects")) {
                this.requiredTotalCrossConnects(model.getRequiredTotalCrossConnects());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            return this;
        }
    }

    public static enum SupportedVirtualCircuitTypes implements BmcEnum
    {
        Public("PUBLIC"),
        Private("PRIVATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SupportedVirtualCircuitTypes> map;

        private SupportedVirtualCircuitTypes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SupportedVirtualCircuitTypes create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SupportedVirtualCircuitTypes', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SupportedVirtualCircuitTypes.class);
            map = new HashMap<String, SupportedVirtualCircuitTypes>();
            for (SupportedVirtualCircuitTypes v : SupportedVirtualCircuitTypes.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

