/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DrgRouteRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="destination")
    private final String destination;
    @JsonProperty(value="destinationType")
    private final DestinationType destinationType;
    @JsonProperty(value="nextHopDrgAttachmentId")
    private final String nextHopDrgAttachmentId;
    @JsonProperty(value="routeType")
    private final RouteType routeType;
    @JsonProperty(value="isConflict")
    private final Boolean isConflict;
    @JsonProperty(value="isBlackhole")
    private final Boolean isBlackhole;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="routeProvenance")
    private final RouteProvenance routeProvenance;
    @JsonProperty(value="attributes")
    private final Object attributes;

    @Deprecated
    @ConstructorProperties(value={"destination", "destinationType", "nextHopDrgAttachmentId", "routeType", "isConflict", "isBlackhole", "id", "routeProvenance", "attributes"})
    public DrgRouteRule(String destination, DestinationType destinationType, String nextHopDrgAttachmentId, RouteType routeType, Boolean isConflict, Boolean isBlackhole, String id, RouteProvenance routeProvenance, Object attributes) {
        this.destination = destination;
        this.destinationType = destinationType;
        this.nextHopDrgAttachmentId = nextHopDrgAttachmentId;
        this.routeType = routeType;
        this.isConflict = isConflict;
        this.isBlackhole = isBlackhole;
        this.id = id;
        this.routeProvenance = routeProvenance;
        this.attributes = attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDestination() {
        return this.destination;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public String getNextHopDrgAttachmentId() {
        return this.nextHopDrgAttachmentId;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public Boolean getIsConflict() {
        return this.isConflict;
    }

    public Boolean getIsBlackhole() {
        return this.isBlackhole;
    }

    public String getId() {
        return this.id;
    }

    public RouteProvenance getRouteProvenance() {
        return this.routeProvenance;
    }

    public Object getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrgRouteRule(");
        sb.append("super=").append(super.toString());
        sb.append("destination=").append(String.valueOf(this.destination));
        sb.append(", destinationType=").append(String.valueOf((Object)this.destinationType));
        sb.append(", nextHopDrgAttachmentId=").append(String.valueOf(this.nextHopDrgAttachmentId));
        sb.append(", routeType=").append(String.valueOf((Object)this.routeType));
        sb.append(", isConflict=").append(String.valueOf(this.isConflict));
        sb.append(", isBlackhole=").append(String.valueOf(this.isBlackhole));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", routeProvenance=").append(String.valueOf((Object)this.routeProvenance));
        sb.append(", attributes=").append(String.valueOf(this.attributes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrgRouteRule)) {
            return false;
        }
        DrgRouteRule other = (DrgRouteRule)((Object)o);
        return Objects.equals(this.destination, other.destination) && Objects.equals((Object)this.destinationType, (Object)other.destinationType) && Objects.equals(this.nextHopDrgAttachmentId, other.nextHopDrgAttachmentId) && Objects.equals((Object)this.routeType, (Object)other.routeType) && Objects.equals(this.isConflict, other.isConflict) && Objects.equals(this.isBlackhole, other.isBlackhole) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.routeProvenance, (Object)other.routeProvenance) && Objects.equals(this.attributes, other.attributes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.destination == null ? 43 : this.destination.hashCode());
        result = result * 59 + (this.destinationType == null ? 43 : this.destinationType.hashCode());
        result = result * 59 + (this.nextHopDrgAttachmentId == null ? 43 : this.nextHopDrgAttachmentId.hashCode());
        result = result * 59 + (this.routeType == null ? 43 : this.routeType.hashCode());
        result = result * 59 + (this.isConflict == null ? 43 : this.isConflict.hashCode());
        result = result * 59 + (this.isBlackhole == null ? 43 : this.isBlackhole.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.routeProvenance == null ? 43 : this.routeProvenance.hashCode());
        result = result * 59 + (this.attributes == null ? 43 : this.attributes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DestinationType implements BmcEnum
    {
        CidrBlock("CIDR_BLOCK"),
        ServiceCidrBlock("SERVICE_CIDR_BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DestinationType> map;

        private DestinationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DestinationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DestinationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DestinationType.class);
            map = new HashMap<String, DestinationType>();
            for (DestinationType v : DestinationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RouteType implements BmcEnum
    {
        Static("STATIC"),
        Dynamic("DYNAMIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RouteType> map;

        private RouteType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RouteType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RouteType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RouteType.class);
            map = new HashMap<String, RouteType>();
            for (RouteType v : RouteType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RouteProvenance implements BmcEnum
    {
        Static("STATIC"),
        Vcn("VCN"),
        VirtualCircuit("VIRTUAL_CIRCUIT"),
        IpsecTunnel("IPSEC_TUNNEL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RouteProvenance> map;

        private RouteProvenance(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RouteProvenance create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RouteProvenance', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RouteProvenance.class);
            map = new HashMap<String, RouteProvenance>();
            for (RouteProvenance v : RouteProvenance.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="destination")
        private String destination;
        @JsonProperty(value="destinationType")
        private DestinationType destinationType;
        @JsonProperty(value="nextHopDrgAttachmentId")
        private String nextHopDrgAttachmentId;
        @JsonProperty(value="routeType")
        private RouteType routeType;
        @JsonProperty(value="isConflict")
        private Boolean isConflict;
        @JsonProperty(value="isBlackhole")
        private Boolean isBlackhole;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="routeProvenance")
        private RouteProvenance routeProvenance;
        @JsonProperty(value="attributes")
        private Object attributes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder destination(String destination) {
            this.destination = destination;
            this.__explicitlySet__.add("destination");
            return this;
        }

        public Builder destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            this.__explicitlySet__.add("destinationType");
            return this;
        }

        public Builder nextHopDrgAttachmentId(String nextHopDrgAttachmentId) {
            this.nextHopDrgAttachmentId = nextHopDrgAttachmentId;
            this.__explicitlySet__.add("nextHopDrgAttachmentId");
            return this;
        }

        public Builder routeType(RouteType routeType) {
            this.routeType = routeType;
            this.__explicitlySet__.add("routeType");
            return this;
        }

        public Builder isConflict(Boolean isConflict) {
            this.isConflict = isConflict;
            this.__explicitlySet__.add("isConflict");
            return this;
        }

        public Builder isBlackhole(Boolean isBlackhole) {
            this.isBlackhole = isBlackhole;
            this.__explicitlySet__.add("isBlackhole");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder routeProvenance(RouteProvenance routeProvenance) {
            this.routeProvenance = routeProvenance;
            this.__explicitlySet__.add("routeProvenance");
            return this;
        }

        public Builder attributes(Object attributes) {
            this.attributes = attributes;
            this.__explicitlySet__.add("attributes");
            return this;
        }

        public DrgRouteRule build() {
            DrgRouteRule model = new DrgRouteRule(this.destination, this.destinationType, this.nextHopDrgAttachmentId, this.routeType, this.isConflict, this.isBlackhole, this.id, this.routeProvenance, this.attributes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrgRouteRule model) {
            if (model.wasPropertyExplicitlySet("destination")) {
                this.destination(model.getDestination());
            }
            if (model.wasPropertyExplicitlySet("destinationType")) {
                this.destinationType(model.getDestinationType());
            }
            if (model.wasPropertyExplicitlySet("nextHopDrgAttachmentId")) {
                this.nextHopDrgAttachmentId(model.getNextHopDrgAttachmentId());
            }
            if (model.wasPropertyExplicitlySet("routeType")) {
                this.routeType(model.getRouteType());
            }
            if (model.wasPropertyExplicitlySet("isConflict")) {
                this.isConflict(model.getIsConflict());
            }
            if (model.wasPropertyExplicitlySet("isBlackhole")) {
                this.isBlackhole(model.getIsBlackhole());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("routeProvenance")) {
                this.routeProvenance(model.getRouteProvenance());
            }
            if (model.wasPropertyExplicitlySet("attributes")) {
                this.attributes(model.getAttributes());
            }
            return this;
        }
    }
}

