/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.core.ComputeManagement;
import com.oracle.bmc.core.model.ClusterNetwork;
import com.oracle.bmc.core.model.InstancePool;
import com.oracle.bmc.core.model.InstancePoolInstance;
import com.oracle.bmc.core.model.InstancePoolLoadBalancerAttachment;
import com.oracle.bmc.core.requests.AttachInstancePoolInstanceRequest;
import com.oracle.bmc.core.requests.CreateClusterNetworkRequest;
import com.oracle.bmc.core.requests.DetachInstancePoolInstanceRequest;
import com.oracle.bmc.core.requests.GetClusterNetworkRequest;
import com.oracle.bmc.core.requests.GetInstancePoolInstanceRequest;
import com.oracle.bmc.core.requests.GetInstancePoolLoadBalancerAttachmentRequest;
import com.oracle.bmc.core.requests.GetInstancePoolRequest;
import com.oracle.bmc.core.requests.LaunchInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.TerminateClusterNetworkRequest;
import com.oracle.bmc.core.responses.AttachInstancePoolInstanceResponse;
import com.oracle.bmc.core.responses.CreateClusterNetworkResponse;
import com.oracle.bmc.core.responses.DetachInstancePoolInstanceResponse;
import com.oracle.bmc.core.responses.GetClusterNetworkResponse;
import com.oracle.bmc.core.responses.GetInstancePoolInstanceResponse;
import com.oracle.bmc.core.responses.GetInstancePoolLoadBalancerAttachmentResponse;
import com.oracle.bmc.core.responses.GetInstancePoolResponse;
import com.oracle.bmc.core.responses.LaunchInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.TerminateClusterNetworkResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ComputeManagementWaiters {
    @Nonnull
    private final ExecutorService executorService;
    @Nonnull
    private final ComputeManagement client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public ComputeManagementWaiters(@Nonnull ExecutorService executorService, @Nonnull ComputeManagement client) {
        this(executorService, client, null);
    }

    public ComputeManagementWaiters(@Nonnull ExecutorService executorService, @Nonnull ComputeManagement client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<AttachInstancePoolInstanceRequest, AttachInstancePoolInstanceResponse> forAttachInstancePoolInstance(AttachInstancePoolInstanceRequest request) {
        return this.forAttachInstancePoolInstance(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<AttachInstancePoolInstanceRequest, AttachInstancePoolInstanceResponse> forAttachInstancePoolInstance(final AttachInstancePoolInstanceRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<AttachInstancePoolInstanceResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public AttachInstancePoolInstanceResponse call() throws Exception {
                AttachInstancePoolInstanceResponse response = this.this$0.client.attachInstancePoolInstance(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    this.this$0.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateClusterNetworkRequest, CreateClusterNetworkResponse> forCreateClusterNetwork(CreateClusterNetworkRequest request) {
        return this.forCreateClusterNetwork(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateClusterNetworkRequest, CreateClusterNetworkResponse> forCreateClusterNetwork(final CreateClusterNetworkRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateClusterNetworkResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CreateClusterNetworkResponse call() throws Exception {
                CreateClusterNetworkResponse response = this.this$0.client.createClusterNetwork(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    this.this$0.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DetachInstancePoolInstanceRequest, DetachInstancePoolInstanceResponse> forDetachInstancePoolInstance(DetachInstancePoolInstanceRequest request) {
        return this.forDetachInstancePoolInstance(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DetachInstancePoolInstanceRequest, DetachInstancePoolInstanceResponse> forDetachInstancePoolInstance(final DetachInstancePoolInstanceRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DetachInstancePoolInstanceResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public DetachInstancePoolInstanceResponse call() throws Exception {
                DetachInstancePoolInstanceResponse response = this.this$0.client.detachInstancePoolInstance(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    this.this$0.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(GetClusterNetworkRequest request, ClusterNetwork.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forClusterNetwork(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(GetClusterNetworkRequest request, ClusterNetwork.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forClusterNetwork(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(GetClusterNetworkRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ClusterNetwork.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forClusterNetwork(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(BmcGenericWaiter waiter, GetClusterNetworkRequest request, ClusterNetwork.LifecycleState ... targetStates) {
        final HashSet<ClusterNetwork.LifecycleState> targetStatesSet = new HashSet<ClusterNetwork.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetClusterNetworkRequest, GetClusterNetworkResponse>(){

            @Override
            public GetClusterNetworkResponse apply(GetClusterNetworkRequest request) {
                return ComputeManagementWaiters.this.client.getClusterNetwork(request);
            }
        }, (Predicate)new Predicate<GetClusterNetworkResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetClusterNetworkResponse response) {
                return targetStatesSet.contains((Object)response.getClusterNetwork().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ClusterNetwork.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(GetInstancePoolRequest request, InstancePool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstancePool(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(GetInstancePoolRequest request, InstancePool.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstancePool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(GetInstancePoolRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstancePool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstancePool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(BmcGenericWaiter waiter, GetInstancePoolRequest request, InstancePool.LifecycleState ... targetStates) {
        final HashSet<InstancePool.LifecycleState> targetStatesSet = new HashSet<InstancePool.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInstancePoolRequest, GetInstancePoolResponse>(){

            @Override
            public GetInstancePoolResponse apply(GetInstancePoolRequest request) {
                return ComputeManagementWaiters.this.client.getInstancePool(request);
            }
        }, (Predicate)new Predicate<GetInstancePoolResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetInstancePoolResponse response) {
                return targetStatesSet.contains((Object)response.getInstancePool().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InstancePool.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetInstancePoolInstanceRequest, GetInstancePoolInstanceResponse> forInstancePoolInstance(GetInstancePoolInstanceRequest request, InstancePoolInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstancePoolInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstancePoolInstanceRequest, GetInstancePoolInstanceResponse> forInstancePoolInstance(GetInstancePoolInstanceRequest request, InstancePoolInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstancePoolInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInstancePoolInstanceRequest, GetInstancePoolInstanceResponse> forInstancePoolInstance(GetInstancePoolInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstancePoolInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstancePoolInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInstancePoolInstanceRequest, GetInstancePoolInstanceResponse> forInstancePoolInstance(BmcGenericWaiter waiter, GetInstancePoolInstanceRequest request, InstancePoolInstance.LifecycleState ... targetStates) {
        final HashSet<InstancePoolInstance.LifecycleState> targetStatesSet = new HashSet<InstancePoolInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInstancePoolInstanceRequest, GetInstancePoolInstanceResponse>(){

            @Override
            public GetInstancePoolInstanceResponse apply(GetInstancePoolInstanceRequest request) {
                return ComputeManagementWaiters.this.client.getInstancePoolInstance(request);
            }
        }, (Predicate)new Predicate<GetInstancePoolInstanceResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetInstancePoolInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getInstancePoolInstance().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, InstancePoolLoadBalancerAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstancePoolLoadBalancerAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, InstancePoolLoadBalancerAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstancePoolLoadBalancerAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstancePoolLoadBalancerAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstancePoolLoadBalancerAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(BmcGenericWaiter waiter, GetInstancePoolLoadBalancerAttachmentRequest request, InstancePoolLoadBalancerAttachment.LifecycleState ... targetStates) {
        final HashSet<InstancePoolLoadBalancerAttachment.LifecycleState> targetStatesSet = new HashSet<InstancePoolLoadBalancerAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse>(){

            @Override
            public GetInstancePoolLoadBalancerAttachmentResponse apply(GetInstancePoolLoadBalancerAttachmentRequest request) {
                return ComputeManagementWaiters.this.client.getInstancePoolLoadBalancerAttachment(request);
            }
        }, (Predicate)new Predicate<GetInstancePoolLoadBalancerAttachmentResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(GetInstancePoolLoadBalancerAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getInstancePoolLoadBalancerAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> forLaunchInstanceConfiguration(LaunchInstanceConfigurationRequest request) {
        return this.forLaunchInstanceConfiguration(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> forLaunchInstanceConfiguration(final LaunchInstanceConfigurationRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<LaunchInstanceConfigurationResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public LaunchInstanceConfigurationResponse call() throws Exception {
                LaunchInstanceConfigurationResponse response = this.this$0.client.launchInstanceConfiguration(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    this.this$0.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> forTerminateClusterNetwork(TerminateClusterNetworkRequest request) {
        return this.forTerminateClusterNetwork(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> forTerminateClusterNetwork(final TerminateClusterNetworkRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<TerminateClusterNetworkResponse>(){
            final /* synthetic */ ComputeManagementWaiters this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TerminateClusterNetworkResponse call() throws Exception {
                TerminateClusterNetworkResponse response = this.this$0.client.terminateClusterNetwork(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    this.this$0.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }
}

