/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cpat.executors;

import com.oracle.premigration.api.Premigration;
import com.oracle.premigration.cli.CommandInvocationMode;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.ResultLevel;
import com.oracle.premigration.commons.enums.TargetCloud;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.cpat.CpatResources;
import oracle.dbtools.cpat.PostProcessorResources;
import oracle.dbtools.cpat.commands.MigrateAdvisorOptions;
import oracle.dbtools.cpat.common.CpatArguments;
import oracle.dbtools.cpat.common.CpatModel;
import oracle.dbtools.cpat.common.CpatOptionValues;
import oracle.dbtools.cpat.exceptions.ProcessFailedException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;

public class CpatExecutor {
    private CpatModel _model;
    private CpatOptionValues _optionValues;
    private ScriptRunnerContext _ctx;

    public CpatExecutor(CpatModel model) {
        this._model = model;
    }

    public boolean exec() throws ProcessFailedException {
        this._optionValues = this._model.getOptionValues();
        this._ctx = this._model.getCtx();
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(CpatResources.getString("CP_EXEC"));
        }
        this._ctx.write(System.lineSeparator());
        this.highLevelDebug();
        this._model.getToolLogger().flushLog();
        try {
            String[] args = this._model.getGenArray();
            if (!DBUtil.isOracleConnectionAlive((Connection)this._ctx.getCurrentConnection())) {
                this._ctx.write("Connection is not alive\n");
            } else {
                this._ctx.write(System.lineSeparator());
                this._model.setExitCode(this.run());
                if (this._model.getExitCode() == 4 || this._model.getExitCode() == 255) {
                    this.doDebugDisplay(this._model.getExitCode() + ": " + PostProcessorResources.get("POST_FATAL_REPORT_DESC"));
                }
            }
        }
        catch (Exception e) {
            this.doDebugDisplay(e.getLocalizedMessage());
            this.doDebug(e);
            this._model.isValid(false);
            throw new ProcessFailedException(e, e.getLocalizedMessage());
        }
        finally {
            this._model.renameUserFileLocations();
        }
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessEnd();
        }
        this._model.getToolLogger().flushLog();
        return this._model.isValid();
    }

    /*
     * WARNING - void declaration
     */
    private int run() throws ProcessFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutput);
            EnvironmentContext environmentContext = new EnvironmentContext(CommandInvocationMode.RUN_FROM_SQLCL, new PrintStream((OutputStream)(this._model.isInfo() ? this._ctx.getOutputStream() : bufferedOutputStream), true, this._ctx.getEncoding()), pw, this._ctx.getCurrentConnection());
            if (this._model.isAdvise()) {
                void var10_19;
                TargetCloud cloudType = this.toTargetCloudType(MigrateAdvisorOptions.Symbol.TARGETTYPE);
                boolean forceFull = this._optionValues.getOptionBoolean(MigrateAdvisorOptions.Symbol.FULL);
                ArrayList<MigrationMethod> migrationMethods = new ArrayList<MigrationMethod>();
                for (String string : this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.MIGRATIONMETHOD)) {
                    migrationMethods.add(CpatExecutor.toMigrationMethodType(string));
                }
                ArrayList<ReportFormat> reportFormats = new ArrayList<ReportFormat>();
                for (String format : this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.REPORTFORMAT)) {
                    ReportFormat reportFormat = CpatExecutor.toReportFormatType(format);
                    if (reportFormats.contains(reportFormat)) continue;
                    reportFormats.add(reportFormat);
                }
                List<String> list = this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.SCHEMAS);
                ArrayList xschemas = this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.EXCLUDESCHEMAS);
                ArrayList<String> schemasUnquoted = new ArrayList<String>();
                if (list != null) {
                    for (String curSchema : list) {
                        schemasUnquoted.add(StringUtils.unQuote((String)curSchema));
                    }
                    ArrayList<String> arrayList = schemasUnquoted;
                }
                if (xschemas != null) {
                    schemasUnquoted = new ArrayList();
                    for (String curSchema : xschemas) {
                        schemasUnquoted.add(StringUtils.unQuote((String)curSchema));
                    }
                    xschemas = schemasUnquoted;
                }
                int n = Premigration.run((CommandLineArgs)CommandLineArgs.builder().targetCloud(cloudType).forceFull(this._optionValues.getOptionBoolean(MigrateAdvisorOptions.Symbol.FULL)).schemas((List)(var10_19 != null ? var10_19 : new ArrayList())).excludeSchemas((List)(xschemas != null ? xschemas : new ArrayList())).migrationMethods(migrationMethods).reportFormats(reportFormats).analysisPropertiesFile(this._optionValues.getOptionString(MigrateAdvisorOptions.Symbol.ANALYSISPROPS)).maxTextRows(this._optionValues.getOptionInteger(MigrateAdvisorOptions.Symbol.MAXTEXTDATAROWS)).sqlInTextReport(this._optionValues.getOptionBoolean(MigrateAdvisorOptions.Symbol.SQLTEXT)).maxRelevantObjects(this._optionValues.getOptionInteger(MigrateAdvisorOptions.Symbol.MAXRELEVANTOBJECTS)).analysisPropertiesFile(this._optionValues.getOptionString(MigrateAdvisorOptions.Symbol.ANALYSISPROPS)).outFilePrefix(this._model.getWorkingPrefix()).outdir(this._optionValues.getOptionString(MigrateAdvisorOptions.Symbol.OUTDIR)).loggingLevel(Level.INFO).resultLevel(ResultLevel.R0).build(), (EnvironmentContext)environmentContext);
                return n;
            }
            if (this._model.isProperties()) {
                int n = Premigration.run((CommandLineArgs)CommandLineArgs.builder().outdir(this._optionValues.getOptionString(MigrateAdvisorOptions.Symbol.OUTDIR)).outFilePrefix(this._model.getWorkingPrefix()).fetchTargetProps(Boolean.valueOf(true)).loggingLevel(Level.INFO).build(), (EnvironmentContext)environmentContext);
                return n;
            }
            int n = Premigration.run((CommandLineArgs)CommandLineArgs.builder().version(Boolean.valueOf(true)).build(), (EnvironmentContext)environmentContext);
            return n;
        }
        catch (Exception e) {
            ProcessFailedException pfe = new ProcessFailedException(e, CpatResources.getString("CPEXE_CPAT_ARG_ERR"));
            pfe.initCause(e);
            throw pfe;
        }
        finally {
            pw.flush();
            String errs = sw.toString();
            if (errs != null && !errs.isEmpty()) {
                this._ctx.write(errs);
                pw.close();
                this._model.isValid(false);
            }
        }
    }

    private static ReportFormat toReportFormatType(String reportFormat) throws ProcessFailedException {
        try {
            return ReportFormat.valueOf((String)reportFormat.toUpperCase());
        }
        catch (Exception e) {
            ProcessFailedException pfException = new ProcessFailedException(e, CpatResources.format("CPPRE_INVALID_VALUE", "reportformat"));
            pfException.initCause(e);
            throw pfException;
        }
    }

    private static MigrationMethod toMigrationMethodType(String mm) throws ProcessFailedException {
        try {
            return MigrationMethod.valueOf((String)mm.toUpperCase());
        }
        catch (Exception e) {
            ProcessFailedException pfException = new ProcessFailedException(e, CpatResources.format("CPPRE_INVALID_VALUE", "migrationmethod"));
            pfException.initCause(e);
            throw pfException;
        }
    }

    private TargetCloud toTargetCloudType(Id opt) throws ProcessFailedException {
        try {
            return TargetCloud.valueOf((String)this._optionValues.getOptionString(opt).toUpperCase());
        }
        catch (Exception e) {
            ProcessFailedException pfException = new ProcessFailedException(e, CpatResources.format("CPPRE_INVALID_VALUE", opt));
            pfException.initCause(e);
            throw pfException;
        }
    }

    private void doDebug(String msg) {
        if (this._model.isDebug()) {
            this._model.getToolLogger().log(msg);
        }
    }

    private void doDebug(Exception e) {
        if (this._model.isDebug()) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this._model.getToolLogger().log(sw.toString());
                this._model.getToolLogger().flushLog();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doDebugDisplay(String msg) {
        this._model.getToolLogger().log(CpatResources.format("CPEXEC_INFORMATIONAL_MESSAGE", msg));
    }

    public void highLevelDebug() {
        CpatArguments theargs = this._model.getArgs();
        for (String key : theargs.keySet()) {
            Object o = theargs.get(key);
            if (o == null) {
                this.doDebug(System.lineSeparator() + "-" + key + ":null");
                continue;
            }
            this.doDebug(System.lineSeparator() + "-" + key + ":" + o.toString());
        }
    }
}

