/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.print;

import java.util.ArrayList;
import java.util.List;

public enum PrintTheme {
    HEAVY('\u2554', '\u2557', '\u2514', '\u2518', '\u251c', '\u2524', '\u2566', '\u2534', '\u253c', '\u2500', '\u2502', '\u2551', '\u2560', '\u2563', '\u256c', '\u2550'),
    LIGHT('\u256d', '\u256e', '\u2570', '\u256f', '\u251c', '\u2524', '\u252c', '\u2534', '\u253c', '\u2500', '\u2502', '\u2502', '\u255e', '\u2561', '\u256a', '\u2550'),
    EMPTY(' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '),
    ULTRA_LIGHT(' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '\u2500'),
    HEAVY_ASCII('+', '+', '+', '+', '+', '+', '+', '+', '+', '-', '|', '+', '+', '+', '+', '='),
    ULTRA_LIGHT_ASCII(' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '-');

    final char topLeft;
    final char topRight;
    final char bottomLeft;
    final char bottomRight;
    final char leftCross;
    final char rightCross;
    final char topCross;
    final char bottomCross;
    final char middleCross;
    final char horizontal;
    final char vertical;
    final char headerVertical;
    final char headerLeftCross;
    final char headerRightCross;
    final char headerMiddleCross;
    final char headerHorizontal;

    private PrintTheme(char topLeft, char topRight, char bottomLeft, char bottomRight, char leftCross, char rightCross, char topCross, char bottomCross, char middleCross, char horizontal, char vertical, char headerVertical, char headerLeftCross, char headerRightCross, char headerMiddleCross, char headerHorizontal) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        this.leftCross = leftCross;
        this.rightCross = rightCross;
        this.topCross = topCross;
        this.bottomCross = bottomCross;
        this.middleCross = middleCross;
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.headerVertical = headerVertical;
        this.headerLeftCross = headerLeftCross;
        this.headerRightCross = headerRightCross;
        this.headerMiddleCross = headerMiddleCross;
        this.headerHorizontal = headerHorizontal;
    }

    public static List<String> getAllThemes() {
        ArrayList<String> result = new ArrayList<String>();
        for (PrintTheme value : PrintTheme.values()) {
            result.add(value.toString());
        }
        return result;
    }

    public static PrintTheme getTheme(String themeValue) {
        for (PrintTheme value : PrintTheme.values()) {
            if (!value.toString().equalsIgnoreCase(themeValue)) continue;
            return value;
        }
        return PrintTheme.getDefault();
    }

    public static PrintTheme getDefault() {
        if (System.console() == null || System.getProperty("os.name").toLowerCase().contains("win")) {
            return ULTRA_LIGHT_ASCII;
        }
        return ULTRA_LIGHT;
    }
}

