/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;

public final class Encodings {
    public static final String UTF8_ENCODING = "UTF-8";
    private static String[] _encodings;
    private static String[] _encodingsWithoutAliases;
    private static String _defaultEncoding;

    private Encodings() {
    }

    public static boolean isSupported(String encoding) {
        boolean supported = false;
        try {
            supported = Charset.isSupported(encoding);
            if (!supported) {
                String s = new String(new byte[0], encoding);
                supported = true;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return supported;
    }

    public static String getDefaultEncoding() {
        if (_defaultEncoding == null) {
            InputStreamReader isr = new InputStreamReader(System.in);
            _defaultEncoding = isr.getEncoding().intern();
        }
        return _defaultEncoding;
    }

    public static synchronized String[] getEncodings() {
        Encodings.ensureInit();
        return (String[])_encodings.clone();
    }

    public static synchronized String[] getEncodingsWithoutAlias() {
        Encodings.ensureInit();
        return (String[])_encodingsWithoutAliases.clone();
    }

    public static boolean isDefaultCp1252() {
        return "Cp1252".equalsIgnoreCase(Encodings.getDefaultEncoding());
    }

    private static synchronized void ensureInit() {
        if (_encodings == null) {
            SortedMap<String, Charset> encMap = Charset.availableCharsets();
            TreeSet<String> encodings = new TreeSet<String>(new CharsetComparator());
            TreeSet<String> encodingsWithOutAliases = new TreeSet<String>(new CharsetComparator());
            for (Charset ch : encMap.values()) {
                String chName = ch.name();
                if (chName.length() >= "X-ORACLE-".length() && "X-ORACLE-".equalsIgnoreCase(chName.substring(0, "X-ORACLE-".length()))) continue;
                encodings.add(ch.name());
                encodingsWithOutAliases.add(ch.name());
                Set<String> aliases = ch.aliases();
                encodings.addAll(aliases);
            }
            Encodings.normalizeDefaultEncoding(encodings);
            Encodings.normalizeDefaultEncoding(encodingsWithOutAliases);
            _encodings = encodings.toArray(new String[encodings.size()]);
            _encodingsWithoutAliases = encodingsWithOutAliases.toArray(new String[encodingsWithOutAliases.size()]);
        }
    }

    private static void normalizeDefaultEncoding(Set encodings) {
        String defaultEncoding = Encodings.getDefaultEncoding();
        if (encodings.contains(defaultEncoding)) {
            encodings.remove(defaultEncoding);
        }
        encodings.add(defaultEncoding);
    }

    private static class CharsetComparator
    implements Comparator {
        private CharsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareToIgnoreCase(s2);
        }
    }
}

