/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MultiLineTableFormatter {
    public static FormatedTable format(List<List<String>> data, List<Boolean> isNumber) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        List processedRows = data.stream().map(MultiLineTableFormatter::processRow).collect(Collectors.toList());
        int[] columnWidths = new int[((List)processedRows.get(0)).size()];
        for (List row2 : processedRows) {
            int col = 0;
            for (Cell cell : row2) {
                columnWidths[col] = Math.max(columnWidths[col], cell.getMaxWidth());
                ++col;
            }
        }
        int i = 0;
        while (i < columnWidths.length) {
            int n = i++;
            columnWidths[n] = columnWidths[n] + 3;
        }
        List<Boolean> safeIsNumber = isNumber != null ? isNumber : Collections.nCopies(columnWidths.length, false);
        List<List<String>> formatedRows = processedRows.stream().map(row -> MultiLineTableFormatter.formatRow(row, safeIsNumber, columnWidths)).collect(Collectors.toList());
        return new FormatedTable(formatedRows, columnWidths);
    }

    public static int getVisibleWidth(String text) {
        int width = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (MultiLineTableFormatter.isAnsiEscapeStart(text, i)) {
                i += 2;
                while (i < text.length() && !Character.isLetter(text.charAt(i))) {
                    ++i;
                }
                continue;
            }
            if (MultiLineTableFormatter.isInvisibleCharacter(ch)) continue;
            ++width;
        }
        return width;
    }

    private static List<Cell> processRow(List<String> rawRow) {
        return rawRow.stream().map(s -> new Cell((String)s)).collect(Collectors.toList());
    }

    private static List<String> formatRow(List<Cell> row, List<Boolean> isNumber, int[] columnWidths) {
        ArrayList<String> formatedCells = new ArrayList<String>(row.size());
        StringBuilder formatedCell = new StringBuilder(128);
        int rowHeight = row.stream().mapToInt(Cell::getHeight).max().orElse(0);
        for (int lineIdx = 0; lineIdx < rowHeight; ++lineIdx) {
            int columnIdx = 0;
            formatedCell.setLength(0);
            for (Cell cell : row) {
                String formatedValue = cell.getformated(lineIdx, isNumber.get(columnIdx), columnWidths[columnIdx]);
                formatedCell.append(formatedValue);
                formatedCell.append(' ');
                ++columnIdx;
            }
            formatedCell.append('\n');
            formatedCells.add(formatedCell.toString());
        }
        return formatedCells;
    }

    private static boolean isInvisibleCharacter(char ch) {
        if (Character.isAlphabetic(ch) || Character.isDigit(ch)) {
            return false;
        }
        if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') {
            return false;
        }
        int type = Character.getType(ch);
        return type == 15 || type == 16 || type == 18 || type == 19 || type == 0 || Character.isIdentifierIgnorable(ch);
    }

    private static boolean isAnsiEscapeStart(String text, int index) {
        return index < text.length() - 1 && text.charAt(index) == '\u001b' && text.charAt(index + 1) == '[';
    }

    private static boolean isResetSequence(char[] chars, int start, int length) {
        if (length == 4 && chars[start + 2] == '0' && chars[start + 3] == 'm') {
            return true;
        }
        return length == 3 && chars[start + 2] == 'm';
    }

    private static class Cell {
        private final String[] lines;
        private final int maxWidth;

        public Cell(String content) {
            if (content == null || content.isEmpty()) {
                this.lines = new String[0];
                this.maxWidth = 0;
                return;
            }
            if (content.indexOf("\u001b[") != -1) {
                this.lines = Cell.splitLinesPreservingAnsiFormatting(content);
                this.maxWidth = Arrays.stream(this.lines).mapToInt(MultiLineTableFormatter::getVisibleWidth).max().orElse(0);
            } else {
                this.lines = content.split("\\n");
                this.maxWidth = Arrays.stream(this.lines).mapToInt(String::length).max().orElse(0);
            }
        }

        public int getHeight() {
            return this.lines.length;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        private String getformated(int idx, boolean isNumber, int columnWidth) {
            String line = idx < this.lines.length ? this.lines[idx] : "";
            String padding = " ".repeat(columnWidth - MultiLineTableFormatter.getVisibleWidth(line));
            return isNumber ? padding + line : line + padding;
        }

        private static String[] splitLinesPreservingAnsiFormatting(String txt) {
            if (txt.isEmpty()) {
                return new String[0];
            }
            ArrayList<String> lines = new ArrayList<String>(16);
            StringBuilder line = new StringBuilder(128);
            StringBuilder activeSequence = new StringBuilder(16);
            char[] chars = txt.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char ch = chars[i];
                if (ch == '\u001b' && i + 1 < chars.length && chars[i + 1] == '[') {
                    int start = i;
                    i += 2;
                    while (i < chars.length && !Character.isLetter(chars[i])) {
                        ++i;
                    }
                    if (i < chars.length) {
                        ++i;
                    }
                    line.append(chars, start, i - start);
                    if (MultiLineTableFormatter.isResetSequence(chars, start, i - start)) {
                        activeSequence.setLength(0);
                        continue;
                    }
                    activeSequence.setLength(0);
                    activeSequence.append(chars, start, i - start);
                    continue;
                }
                if (ch == '\n') {
                    if (activeSequence.length() > 0) {
                        line.append("\u001b[m");
                    }
                    lines.add(line.toString());
                    line.setLength(0);
                    if (activeSequence.length() > 0) {
                        line.append((CharSequence)activeSequence);
                    }
                    ++i;
                    continue;
                }
                line.append(ch);
                ++i;
            }
            if (line.length() > 0) {
                lines.add(line.toString());
            }
            return (String[])lines.toArray(String[]::new);
        }
    }

    public static class FormatedTable {
        private final List<List<String>> formatedRows;
        private final int[] columnWidths;

        public List<List<String>> getRows() {
            return this.formatedRows;
        }

        public int[] getColumnWidths() {
            return this.columnWidths;
        }

        public FormatedTable(List<List<String>> formatedRows, int[] columnWidths) {
            this.formatedRows = formatedRows;
            this.columnWidths = columnWidths;
        }
    }
}

