/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.database.AbstractDatabaseTransformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.database.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public class DatabaseTransformerQuery {
    private TransformContext context;
    private Environment environment;

    public DatabaseTransformerQuery(TransformContext context, Environment environment) {
        this.context = context;
        this.environment = environment;
    }

    public static String getQuery(String id, Connection conn) {
        QueryXMLSupport xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(AbstractDatabaseTransformer.class.getClassLoader(), "oracle/dbtools/raptor/newscriptrunner/util/transformer/database/DatabaseQueries.xml"));
        Query q = xml.getQuery(id, conn);
        return q == null ? null : q.getSql();
    }

    protected String executeQuery(String queryId, Map<String, String> binds) {
        Optional<Connection> connOpt = this.environment.getConnection();
        if (connOpt.isEmpty()) {
            this.context.addError(Messages.getString(Messages.Key.CONN_REQ, this.environment.getLocale()));
            return null;
        }
        Connection conn = connOpt.get();
        String query = DatabaseTransformerQuery.getQuery(queryId, conn);
        DBUtil dBUtil = DBUtil.getInstance(conn);
        String result = dBUtil.executeReturnOneCol(query, binds);
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            if (e.getErrorCode() != 44001 && e.getErrorCode() == 17008) {
                this.context.addError(Messages.getString(Messages.Key.CONN_CLOSED, this.environment.getLocale()));
            }
            return null;
        }
        return result;
    }

    protected String executeQuery(String queryId, String bind) {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("VALUE", bind);
        return this.executeQuery(queryId, binds);
    }

    protected Boolean existsQuery(String queryId, Map<String, String> binds) {
        String result = this.executeQuery(queryId, binds);
        if (result == null || result.equals("0")) {
            Object errParm = "";
            for (String value : binds.values()) {
                errParm = (String)errParm + value + " ";
            }
            this.context.addError(MessageFormat.format(Messages.getString(Messages.Key.BAD_PARM_VALUE, this.environment.getLocale()), errParm));
            return null;
        }
        return true;
    }

    protected Boolean existsQuery(String queryId, String bind) {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("VALUE", bind);
        return this.existsQuery(queryId, binds);
    }
}

