/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamePropertiesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Synonyms;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;

public class WordBuilder
extends ExpressionBuilder {
    private final NamePropertiesBuilder namePropertiesBuilder = new NamePropertiesBuilder();

    public WordBuilder helpId(String helpId) {
        this.namePropertiesBuilder.setHelpId(helpId);
        return this;
    }

    public WordBuilder helpId() {
        this.namePropertiesBuilder.setHelpId(null);
        return this;
    }

    public WordBuilder abbrevs(String ... abbrevs) {
        this.namePropertiesBuilder.setAbbrevs(abbrevs);
        return this;
    }

    protected WordBuilder(String name) {
        this.namePropertiesBuilder.setName(Objects.requireNonNull(name));
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new Word(context, this, this.namePropertiesBuilder.build(true)));
    }

    private static class Word
    implements NamedExpression {
        private final String name;
        private final Optional<String> helpId;
        private final Synonyms synonyms;

        Word(GrammarBuildContext context, WordBuilder builder, NamePropertiesBuilder.NameProperties nameProperties) {
            this.name = nameProperties.getName();
            this.helpId = nameProperties.getHelpId();
            this.synonyms = nameProperties.getSynonyms();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> getHelpId() {
            return this.helpId;
        }

        @Override
        public Set<String> getSynonyms() {
            return this.synonyms.get();
        }

        @Override
        public Syntax getSyntax() {
            return this.synonyms.getNameSyntax();
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            if (this.helpId.isPresent()) {
                visitor.accept(this);
            }
        }

        @Override
        public void parse(Node node) {
            Token token = node.next();
            if (token == null) {
                if (node.hasTrailingWhiteSpace()) {
                    node.addCompletion(this.name.toLowerCase());
                }
                node.setParseErrorUsing(token);
            } else if (!this.synonyms.matches(token.getValue())) {
                if (!node.hasTrailingWhiteSpace() && !node.hasMoreTokens() && this.synonyms.startsWith(token.getValue())) {
                    node.addCompletion(this.name.toLowerCase());
                }
                node.setParseErrorUsing(token);
            } else {
                if (!node.hasTrailingWhiteSpace() && !node.hasMoreTokens()) {
                    node.addCompletion(this.name.toLowerCase());
                }
                node.setValue(this.name);
                node.setMatched();
            }
        }

        public String toString() {
            return "WORD";
        }
    }
}

