/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Rule;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public final class RefBuilder
extends ExpressionBuilder {
    private final Transformer<Node, ?> transformer;
    private final Id ruleId;

    protected RefBuilder(Transformer<Node, ?> transformer, Id ruleId) {
        this.transformer = transformer;
        this.ruleId = ruleId;
    }

    public Id getRuleId() {
        return this.ruleId;
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        Ref ref = new Ref(context, this);
        context.addResolver(lookup -> ref.setRule((Rule)lookup.apply(this.ruleId)));
        return context.compose(ref);
    }

    private static class Ref
    implements Expression {
        private final Transformer<Node, ?> transformer;
        private String refName;
        private Expression expression;
        private boolean flattened;

        Ref(GrammarBuildContext context, RefBuilder builder) {
            this.transformer = builder.transformer;
        }

        void setRule(Rule rule) {
            this.refName = rule.getName().toLowerCase();
            this.expression = rule.getExpression();
            this.flattened = rule.isFlattened();
        }

        @Override
        public Syntax getSyntax() {
            if (this.flattened) {
                return this.expression.getSyntax();
            }
            StringBuilder buff = new StringBuilder();
            buff.append('<');
            buff.append(this.refName);
            buff.append('>');
            return new Syntax(buff.toString(), false);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
        }

        @Override
        public void parse(Node node) {
            Node childNode = node.createChildContext(this.expression);
            this.expression.parse(childNode);
            if (childNode.isMatched()) {
                node.addChildNode(childNode);
                node.setValueFrom(childNode, this.transformer);
                node.setMatched();
            } else {
                node.setParseError(childNode.getParseError());
            }
            node.mergeCompletions(childNode.getCompletions());
            node.mergeSemanticErrors(childNode.getSemanticErrors());
        }

        public String toString() {
            return "REF";
        }
    }
}

