/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Optional;
import java.util.Set;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AttributeBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamePropertiesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Synonyms;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.PrimitiveTransformers;

public final class OptionBuilder
extends AttributeBuilder<OptionBuilder> {
    private final NamePropertiesBuilder namePropertiesBuilder = new NamePropertiesBuilder();
    private final Id id;
    private boolean flag;

    public OptionBuilder name(String name) {
        this.namePropertiesBuilder.setName(name);
        return this;
    }

    public OptionBuilder helpId(String helpId) {
        this.namePropertiesBuilder.setHelpId(helpId);
        return this;
    }

    public OptionBuilder helpId() {
        this.namePropertiesBuilder.setHelpId(null);
        return this;
    }

    public OptionBuilder abbrevs(String ... abbrevs) {
        this.namePropertiesBuilder.setAbbrevs(abbrevs);
        return this;
    }

    public OptionBuilder flag() {
        this.flag = true;
        return (OptionBuilder)((OptionBuilder)this.dataType(Boolean.class)).transformer(PrimitiveTransformers.get(Boolean.class));
    }

    public <T> Option<T> build() {
        OptionImpl option = new OptionImpl(this, this.namePropertiesBuilder.build(this.id, true));
        this.validate(option);
        return option;
    }

    protected OptionBuilder(Id id) {
        this.id = id;
    }

    private static class OptionImpl<T>
    extends AttributeBuilder.AttributeImpl<T>
    implements Option<T> {
        private final Id id;
        private final String name;
        private final Optional<String> helpId;
        private final Synonyms synonyms;
        private final boolean flag;
        private Set<String> mutuallyExclusiveGroups = null;

        private OptionImpl(OptionBuilder builder, NamePropertiesBuilder.NameProperties nameProperties) {
            super(builder);
            this.id = builder.id;
            this.flag = builder.flag;
            this.name = nameProperties.getName();
            this.helpId = nameProperties.getHelpId();
            this.synonyms = nameProperties.getSynonyms();
        }

        @Override
        public Id getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> getHelpId() {
            return this.helpId;
        }

        @Override
        public boolean isFlag() {
            return this.flag;
        }

        @Override
        public Syntax getSyntax() {
            StringBuilder buff = new StringBuilder();
            buff.append('-');
            Syntax nameSyntax = this.synonyms.getNameSyntax();
            buff.append(nameSyntax.get());
            return new Syntax(buff.toString(), nameSyntax.bracketIfNested());
        }

        @Override
        public Synonyms getSynonyms() {
            return this.synonyms;
        }
    }
}

