/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.util.help.AbstractPageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStringExtension;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStrings;
import oracle.dbtools.raptor.newscriptrunner.util.help.PageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.help.StructuredHelpPage;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Attribute;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ContainerObjectsBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Grammar;
import oracle.dbtools.raptor.newscriptrunner.util.parser.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedItem;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Rule;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class CommandPageAssemblers
implements Iterable<PageAssembler> {
    private static final String DOUBLE_NEW_LINE = "\n\n";
    private static final String NEW_LINE = "\n";
    private static final String BOLD_MARKER = "\\#";
    private final Type rootType;
    private final Set<Type> excludedTypes;
    private List<PageAssembler> pages;

    public CommandPageAssemblers(Type rootType, Type ... excludeTypes) {
        this.rootType = rootType;
        this.excludedTypes = new HashSet<Type>(Arrays.asList(excludeTypes));
    }

    @Override
    public Iterator<PageAssembler> iterator() {
        return this.getPages().iterator();
    }

    private List<PageAssembler> getPages() {
        if (this.pages == null) {
            this.pages = new ArrayList<PageAssembler>();
            this.addPages(Collections.singletonList(this.rootType), this.pages);
        }
        return this.pages;
    }

    private void addPages(List<Type> typePath, List<PageAssembler> helpAssemblers) {
        Type type = typePath.get(typePath.size() - 1);
        if (type.getHelpId().isPresent() && !this.excludedTypes.contains(type)) {
            helpAssemblers.add(new CommandPageAssembler(typePath));
            helpAssemblers.add(new ExamplesPageAssembler(typePath));
            helpAssemblers.add(new SyntaxPageAssembler(typePath));
        }
        for (Type nestedType : type.getNestedTypes()) {
            ArrayList<Type> nestedTypePath = new ArrayList<Type>(typePath);
            nestedTypePath.add(nestedType);
            this.addPages(nestedTypePath, helpAssemblers);
        }
    }

    private static <T extends NamedItem> Collection<T> sortItemList(boolean alphaSort, Collection<T> items) {
        return alphaSort ? (Collection)items.stream().sorted((left, right) -> left.getName().compareTo(right.getName())).collect(Collectors.toList()) : items;
    }

    private static void appendGrammarRules(Grammar<?> grammar, StringBuilder buff) {
        boolean first = true;
        for (Rule rule : grammar.getRules()) {
            if (rule.isFlattened()) continue;
            if (first) {
                buff.append(' ');
                first = false;
            } else {
                buff.append("\n\t\t");
            }
            buff.append(rule.asBNF());
        }
    }

    private static String getIndentation(int size) {
        if (size <= 0) {
            return "";
        }
        StringBuilder indent = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            indent.append('\t');
        }
        return indent.toString();
    }

    private static class CommandPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;
        private boolean alphaSort;
        private Locale locale;
        private HelpStrings helpStrings;
        private StringBuilder buff;
        private Map<String, Integer> linePositions;
        private String currentPath;
        private int nextSearchFrom = 0;
        private int lineCount = 0;

        private CommandPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        private int getCurrentLineNumber() {
            if (this.buff == null || this.buff.length() == 0) {
                return 0;
            }
            int idx = this.buff.indexOf(CommandPageAssemblers.NEW_LINE, this.nextSearchFrom);
            while (idx != -1) {
                ++this.lineCount;
                this.nextSearchFrom = idx + 1;
                idx = this.buff.indexOf(CommandPageAssemblers.NEW_LINE, this.nextSearchFrom);
            }
            return this.lineCount;
        }

        private void trackLinePosition(String tag) {
            String fullPath = this.currentPath.isEmpty() ? tag : this.currentPath + "/" + tag;
            this.linePositions.put(fullPath.toUpperCase(), this.getCurrentLineNumber() + 1);
        }

        @Override
        public List<HelpContainer> getHelpContainers() {
            ArrayList<HelpContainer> helpContainers = new ArrayList<HelpContainer>();
            int t = this.typePath.size();
            while (t-- > 0) {
                helpContainers.addAll(this.typePath.get(t).getHelpContainers());
            }
            return helpContainers;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            return buff.toString();
        }

        @Override
        public StructuredHelpPage getPage(int lineSize, boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics, boolean enableColorCode) {
            String rawContent = this.buildRawPage(alphaSort, locale, helpStrings);
            AbstractPageAssembler.LayoutHelper layoutHelper = new AbstractPageAssembler.LayoutHelper(lineSize, enableColorCode);
            layoutHelper.layout(rawContent);
            return new StructuredHelpPage(layoutHelper.get(), this.linePositions);
        }

        @Override
        protected String getRawPage(boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics) {
            return this.buildRawPage(alphaSort, locale, helpStrings);
        }

        private String buildRawPage(boolean alphaSort, Locale locale, HelpStrings helpStrings) {
            this.alphaSort = alphaSort;
            this.locale = locale;
            this.helpStrings = helpStrings;
            this.buff = new StringBuilder(512);
            this.linePositions = new HashMap<String, Integer>(16);
            this.currentPath = "";
            this.nextSearchFrom = 0;
            this.lineCount = 0;
            Type type = this.typePath.get(this.typePath.size() - 1);
            this.buff.append(helpStrings.get(type.getHelpId().get()));
            if (!type.isBase()) {
                this.appendUsage(this.buff, locale);
            }
            this.appendGrammarItems(alphaSort, helpStrings, this.buff);
            if (!type.getNestedTypes().isEmpty()) {
                this.appendNestedTypesFlattened(type, 0);
            }
            this.appendAttributesSection(type, "", "\t", HelpMessages.Key.OPTIONS_TITLE, type.getOptions());
            this.appendAttributesSection(type, "", "\t", HelpMessages.Key.PARAMETERS_TITLE, type.getParameters());
            this.appendExamplesSection(type, "", "\t");
            return this.buff.toString();
        }

        private void appendUsage(StringBuilder buff, Locale locale) {
            Grammar<?> grammar;
            this.trackLinePosition("USAGE");
            buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(HelpMessages.getString(HelpMessages.Key.USAGE_TITLE, locale)).append(CommandPageAssemblers.NEW_LINE);
            boolean first = true;
            for (Type type : this.typePath) {
                if (first) {
                    buff.append(CommandPageAssemblers.NEW_LINE).append('\t');
                } else {
                    buff.append(" ");
                }
                buff.append('$').append(type.getSyntax().get()).append('$');
            }
            Type type = this.typePath.get(this.typePath.size() - 1);
            if (!type.getNestedTypes().isEmpty()) {
                buff.append(" {SUBCOMMAND}");
            }
            if (!type.getOptions().isEmpty()) {
                buff.append(" {OPTIONS}");
            }
            if (!type.getParameters().isEmpty()) {
                buff.append(" {PARAMETERS}");
            }
            if ((grammar = type.getGrammar()) != null) {
                CommandPageAssemblers.appendGrammarRules(grammar, buff);
            }
        }

        private void appendGrammarItems(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            Grammar<?> grammar = type.getGrammar();
            if (grammar != null) {
                AbstractMap helpIdMap = alphaSort ? new TreeMap() : new LinkedHashMap();
                for (Rule rule : grammar.getRules()) {
                    Optional<String> helpIdOptional = rule.getHelpId();
                    if (helpIdOptional.isPresent()) {
                        helpIdMap.put(rule.getSyntax().get(), helpIdOptional.get());
                    }
                    rule.getExpression().visitNamedExpressions(expression -> {
                        Optional<String> helpIdOptional = expression.getHelpId();
                        if (helpIdOptional.isPresent()) {
                            helpIdMap.put(expression.getSyntax().get(), helpIdOptional.get());
                        }
                    });
                }
                for (String syntax : helpIdMap.keySet()) {
                    buff.append("\n\n\t$").append(syntax).append("$");
                    buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, (String)helpIdMap.get(syntax)));
                }
            }
        }

        private void appendNestedTypesFlattened(Type type, int depth) {
            String titleIndent = CommandPageAssemblers.getIndentation(depth);
            String commandIndent = CommandPageAssemblers.getIndentation(depth + 1);
            String itemIndent = CommandPageAssemblers.getIndentation(depth + 2);
            this.trackLinePosition("SUBCOMMANDS");
            this.buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(titleIndent).append(HelpMessages.getString(HelpMessages.Key.SUBCOMMANDS_TITLE, this.locale));
            boolean first = true;
            for (Type nestedType : CommandPageAssemblers.sortItemList(this.alphaSort, type.getNestedTypes())) {
                if (nestedType.getHelpId().isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    this.buff.append(CommandPageAssemblers.NEW_LINE);
                }
                this.appendCommandContent(nestedType, commandIndent, itemIndent, depth);
            }
        }

        private void appendCommandContent(Type type, String contentIndent, String itemIndent, int depth) {
            this.trackLinePosition(type.getName());
            String previousPath = this.currentPath;
            this.currentPath = this.currentPath.isEmpty() ? type.getName() : this.currentPath + "/" + type.getName();
            this.buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(contentIndent).append(CommandPageAssemblers.BOLD_MARKER).append(type.getName()).append(CommandPageAssemblers.BOLD_MARKER);
            String fullDescription = this.helpStrings.get(type.getHelpId().get());
            if (fullDescription != null) {
                this.buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(contentIndent).append(fullDescription.replace(CommandPageAssemblers.NEW_LINE, CommandPageAssemblers.NEW_LINE + contentIndent));
            }
            this.appendUsageSection(type, contentIndent, itemIndent);
            if (!type.getNestedTypes().isEmpty()) {
                this.appendNestedTypesFlattened(type, depth + 1);
            }
            this.appendAttributesSection(type, contentIndent, itemIndent, HelpMessages.Key.OPTIONS_TITLE, type.getOptions());
            this.appendAttributesSection(type, contentIndent, itemIndent, HelpMessages.Key.PARAMETERS_TITLE, type.getParameters());
            this.appendExamplesSection(type, contentIndent, itemIndent);
            this.currentPath = previousPath;
        }

        private void appendUsageSection(Type type, String contentIndent, String itemIndent) {
            if (!(type.getNestedTypes().isEmpty() && type.getOptions().isEmpty() && type.getParameters().isEmpty())) {
                this.trackLinePosition("USAGE");
                this.buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(contentIndent).append(HelpMessages.getString(HelpMessages.Key.USAGE_TITLE, this.locale)).append(CommandPageAssemblers.NEW_LINE);
                this.buff.append(CommandPageAssemblers.NEW_LINE).append(itemIndent).append("$").append(type.getSyntax().get().replace("|", "$|$")).append('$');
                if (!type.getNestedTypes().isEmpty()) {
                    this.buff.append(" {SUBCOMMAND}");
                }
                if (!type.getOptions().isEmpty()) {
                    this.buff.append(" {OPTIONS}");
                }
                if (!type.getParameters().isEmpty()) {
                    this.buff.append(" {PARAMETERS}");
                }
            }
        }

        private void appendExamplesSection(Type type, String contentIndent, String itemIndent) {
            String examples = this.helpStrings.get(Extensions.EXAMPLES, type.getHelpId().get());
            if (examples != null && !examples.isBlank()) {
                this.trackLinePosition("EXAMPLES");
                this.buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(contentIndent).append("Examples:").append(CommandPageAssemblers.NEW_LINE);
                this.buff.append(CommandPageAssemblers.NEW_LINE).append(itemIndent).append(examples.replace(CommandPageAssemblers.NEW_LINE, CommandPageAssemblers.NEW_LINE + itemIndent));
            }
        }

        private <T extends Attribute<?>> void appendAttributesSection(Type type, String contentIndent, String itemIndent, HelpMessages.Key titleKey, Collection<T> attributes) {
            if (attributes.isEmpty()) {
                return;
            }
            String sectionName = titleKey == HelpMessages.Key.OPTIONS_TITLE ? "OPTIONS" : "PARAMETERS";
            this.trackLinePosition(sectionName);
            this.buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(contentIndent).append(HelpMessages.getString(titleKey, this.locale)).append(CommandPageAssemblers.NEW_LINE);
            boolean first = true;
            for (Attribute attribute : CommandPageAssemblers.sortItemList(this.alphaSort, attributes)) {
                if (!attribute.getHelpId().isPresent()) continue;
                if (first) {
                    first = false;
                } else {
                    this.buff.append(CommandPageAssemblers.NEW_LINE);
                }
                this.appendAttributeItem(attribute, itemIndent, type);
            }
        }

        private void appendAttributeItem(Attribute<?> attribute, String itemIndent, Type type) {
            String defaultValueStr;
            Option option;
            this.buff.append(CommandPageAssemblers.NEW_LINE).append(itemIndent).append("$");
            if (attribute instanceof Option) {
                this.buff.append(attribute.getSyntax().get().replace("|", "$|$-"));
            } else {
                this.buff.append(attribute.getSyntax().get());
            }
            this.buff.append('$');
            if (attribute instanceof Option && !(option = (Option)attribute).isFlag()) {
                this.buff.append(" <").append(option.getName().toLowerCase()).append(">");
            }
            if (attribute.getTransformer() != null && attribute.getTransformer().getFormat(this.locale) != null) {
                this.buff.append(" {").append(attribute.getTransformer().getFormat(this.locale)).append("}");
            }
            if (attribute.getDefaultValue() != null && (attribute instanceof Parameter || attribute instanceof Option && !((Option)attribute).isFlag()) && (defaultValueStr = attribute.getDefaultValueAsString()) != null) {
                this.buff.append(" (").append(defaultValueStr.isEmpty() ? "\"\"" : defaultValueStr).append(")");
            }
            if (attribute.isRequired()) {
                this.buff.append(" [").append(HelpMessages.getString(HelpMessages.Key.REQUIRED, this.locale)).append("]");
            }
            this.appendMutualExclusivityInfo(this.buff, attribute, type, this.locale);
            String summary = this.helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, attribute.getHelpId().get());
            if (summary != null) {
                this.buff.append(CommandPageAssemblers.NEW_LINE).append(itemIndent).append(summary.replace(CommandPageAssemblers.NEW_LINE, CommandPageAssemblers.NEW_LINE + itemIndent));
            }
        }

        private void appendMoreTopics(boolean alphaSort, List<String> moreHelpCommands, StringBuilder buff, Locale locale) {
            buff.append(CommandPageAssemblers.DOUBLE_NEW_LINE).append(HelpMessages.getString(HelpMessages.Key.MORE_TITLE, locale));
            for (String moreHelpCommand : this.sortStringList(alphaSort, moreHelpCommands)) {
                buff.append("\n\t").append(moreHelpCommand);
            }
        }

        private List<String> sortStringList(boolean alphaSort, List<String> items) {
            return alphaSort ? items.stream().sorted((left, right) -> left.compareTo((String)right)).collect(Collectors.toList()) : items;
        }

        private void appendMutualExclusivityInfo(StringBuilder buff, Attribute<?> attribute, Type type, Locale locale) {
            Map<String, ContainerObjectsBuilder.MutexGroupMetadata> mutexGroupsMetadata = type.getMutexGroupsMetadata();
            for (ContainerObjectsBuilder.MutexGroupMetadata groupMetadata : mutexGroupsMetadata.values()) {
                if (!groupMetadata.getAttributeIds().contains(attribute.getId())) continue;
                List<String> groupMembers = this.findGroupMembersFromMetadata(groupMetadata, type);
                groupMembers.removeIf(name -> name.equals(attribute.getName()));
                if (groupMetadata.isRequired()) {
                    buff.append(" [Required, exactly one of: ");
                } else {
                    buff.append(" [Mutually exclusive with: ");
                }
                buff.append(String.join((CharSequence)", ", groupMembers)).append(']');
            }
        }

        private List<String> findGroupMembersFromMetadata(ContainerObjectsBuilder.MutexGroupMetadata groupMetadata, Type type) {
            ArrayList<String> members = new ArrayList<String>();
            block0: for (Id attributeId : groupMetadata.getAttributeIds()) {
                for (Option<?> option : type.getOptions()) {
                    if (!option.getId().equals(attributeId)) continue;
                    members.add(option.getName());
                    break;
                }
                for (Parameter parameter : type.getParameters()) {
                    if (!parameter.getId().equals(attributeId)) continue;
                    members.add(parameter.getName());
                    continue block0;
                }
            }
            Collections.sort(members);
            return members;
        }
    }

    private static class ExamplesPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;

        private ExamplesPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            buff.append("/EXAMPLES");
            return buff.toString();
        }

        @Override
        protected String getRawPage(boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            StringBuilder buff = new StringBuilder();
            buff.append(helpStrings.get(Extensions.EXAMPLES, type.getHelpId().get()));
            return buff.toString();
        }
    }

    private static class SyntaxPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;

        private SyntaxPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            buff.append("/SYNTAX");
            return buff.toString();
        }

        @Override
        protected String getRawPage(boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics) {
            StringBuilder buff = new StringBuilder();
            SyntaxPageAssembler.appendSyntax(this.typePath, alphaSort, buff, locale);
            return buff.toString();
        }

        private static void appendSyntax(List<Type> typePath, boolean alphaSort, StringBuilder buff, Locale locale) {
            Grammar<?> grammar;
            boolean first = true;
            for (Type type : typePath) {
                if (first) {
                    buff.append("\t");
                    first = false;
                } else {
                    buff.append(" ");
                }
                buff.append('$').append(type.getSyntax().get().replace("|", "$|$")).append('$');
            }
            Type type = typePath.get(typePath.size() - 1);
            if (!type.getNestedTypes().isEmpty()) {
                if (!type.isBase()) {
                    buff.append(" [");
                }
                boolean firstType = true;
                for (Type nestedType : CommandPageAssemblers.sortItemList(alphaSort, type.getNestedTypes())) {
                    if (firstType) {
                        firstType = false;
                    } else {
                        buff.append(" |");
                    }
                    buff.append(" ");
                    if (nestedType.getSyntax().get().contains("|")) {
                        buff.append("[");
                    }
                    buff.append("$").append(nestedType.getSyntax().get().replace("|", "$|$")).append("$");
                    if (!nestedType.getSyntax().get().contains("|")) continue;
                    buff.append("]");
                }
                if (!type.isBase()) {
                    buff.append(" ] | [");
                }
            }
            if (!type.getOptions().isEmpty()) {
                for (Option<?> option : CommandPageAssemblers.sortItemList(alphaSort, type.getOptions())) {
                    buff.append(" ");
                    if (!option.isRequired()) {
                        buff.append("[");
                    }
                    buff.append("$").append(option.getSyntax().get().replace("|", "$|$-")).append("$");
                    if (!option.isFlag()) {
                        buff.append(" <").append(option.getName().toLowerCase()).append(">");
                    }
                    if (option.isRequired()) continue;
                    buff.append("]");
                }
            }
            if (!type.getParameters().isEmpty()) {
                for (Parameter<?> parameter : CommandPageAssemblers.sortItemList(alphaSort, type.getParameters())) {
                    buff.append(" ");
                    if (!parameter.isRequired()) {
                        buff.append("[");
                    }
                    buff.append("<").append(parameter.getName().toLowerCase()).append(">");
                    if (parameter.isRequired()) continue;
                    buff.append("]");
                }
            }
            if ((grammar = type.getGrammar()) != null) {
                CommandPageAssemblers.appendGrammarRules(grammar, buff);
            }
            if (!type.getNestedTypes().isEmpty() && !type.isBase()) {
                buff.append(" ]");
            }
        }
    }

    public static enum Extensions implements HelpStringExtension
    {
        EXAMPLES{

            @Override
            public String getDefault() {
                return "EX";
            }
        };

    }
}

