/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowLinesize
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWLINESIZE = new String[]{"lin", "line", "lines", "linesi", "linesiz", "linesize"};

    @Override
    public String[] getShowAliases() {
        return SHOWLINESIZE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowLinesize(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowLinesize(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Integer val = (Integer)ctx.getProperty("script.runner.setlinesize");
        String str = MessageFormat.format(Messages.getString("LINESIZE"), val.toString()) + Show.m_lineSeparator;
        ctx.write(str);
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("linesize", String.valueOf(ctx.getProperty("script.runner.setlinesize")));
    }
}

