/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowJdbc
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWJDBC = new String[]{"jdbc"};

    @Override
    public String[] getShowAliases() {
        return SHOWJDBC;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() != null) {
            return this.doShowJDBC(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private String resourceLookup(String lookupResourceName) {
        try {
            URL url;
            if (lookupResourceName == null || ((String)lookupResourceName).length() == 0) {
                return "";
            }
            if (((String)lookupResourceName).indexOf("/") == -1) {
                lookupResourceName = ((String)lookupResourceName).replaceAll("[.]", "/");
                lookupResourceName = "/" + (String)lookupResourceName + ".class";
            }
            if ((url = this.getClass().getResource((String)lookupResourceName)) == null) {
                return "Unable to locate resource " + (String)lookupResourceName;
            }
            String resourceUrl = url.toExternalForm();
            Pattern pattern = Pattern.compile("(zip:|jar:file:/)(.*)!/(.*)", 2);
            Object jarFilename = null;
            String resourceFilename = null;
            Matcher m = pattern.matcher(resourceUrl);
            if (!m.find()) {
                return "Unable to parse URL: " + resourceUrl;
            }
            jarFilename = m.group(2);
            resourceFilename = m.group(3);
            if (!((String)jarFilename).startsWith("C:")) {
                jarFilename = "/" + (String)jarFilename;
            }
            File file = new File((String)jarFilename);
            Long jarSize = null;
            Date jarDate = null;
            Long resourceSize = null;
            Date resourceDate = null;
            if (file.exists() && file.isFile()) {
                jarSize = file.length();
                jarDate = new Date(file.lastModified());
                try {
                    JarFile jarFile = new JarFile(file, false);
                    ZipEntry entry = jarFile.getEntry(resourceFilename);
                    resourceSize = entry.getSize();
                    resourceDate = new Date(entry.getTime());
                }
                catch (Throwable e) {
                    return "Unable to open JAR" + (String)jarFilename + "   " + resourceUrl + "\n" + e.getMessage();
                }
                return "\nresource: " + resourceFilename + "\njar: " + (String)jarFilename + "  \nJarSize: " + jarSize + "  \nJarDate: " + jarDate.toString() + "  \nresourceSize: " + resourceSize + "  \nresourceDate: " + resourceDate.toString() + "\n";
            }
            return "Unable to load jar:" + (String)jarFilename + "  \nUrl: " + resourceUrl;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doShowJDBC(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        StringBuffer sb;
        block6: {
            sb = new StringBuffer();
            try {
                if (!LockManager.lock(conn)) break block6;
                try {
                    DatabaseMetaData dbmd = conn.getMetaData();
                    sb.append("-- Database Info --\n");
                    sb.append("Database Product Name: " + dbmd.getDatabaseProductName() + "\n");
                    sb.append("Database Product Version: " + dbmd.getDatabaseProductVersion() + "\n");
                    sb.append("Database Major Version: " + dbmd.getDatabaseMajorVersion() + "\n");
                    sb.append("Database Minor Version: " + dbmd.getDatabaseMinorVersion() + "\n");
                    sb.append("-- Driver Info --\n");
                    sb.append("Driver Name: " + dbmd.getDriverName() + "\n");
                    sb.append("Driver Version: " + dbmd.getDriverVersion() + "\n");
                    sb.append("Driver Major Version: " + dbmd.getDriverMajorVersion() + "\n");
                    sb.append("Driver Minor Version: " + dbmd.getDriverMinorVersion() + "\n");
                    if (!ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
                        sb.append("Driver URL: " + dbmd.getURL() + "\n");
                    }
                    sb.append("Driver Location: " + this.resourceLookup("oracle.jdbc.OracleDriver") + "\n");
                }
                finally {
                    LockManager.unlock(conn);
                }
            }
            catch (Exception e) {
                sb.append("\nUnable to gather information\n");
            }
        }
        ctx.write(sb.toString());
        return true;
    }
}

