/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowConname
implements IShowCommand {
    private static final String SHOWCONNAME = "con_name";
    private static final String[] BOTH = new String[]{"con_name", "con_id"};
    private static final String preAmble = new StringBuffer("DECLARE \n").append("CHECKONE VARCHAR2(1000):=NULL; \n").append("BEGIN \n").append(" BEGIN \n").append("   CHECKONE:=").toString();
    private static final String postAmble = new StringBuffer(";\n EXCEPTION \n").append(" WHEN OTHERS THEN \n").append("  CHECKONE :=NULL; \n").append(" END; \n").append(" :CHECKFORONE:=CHECKONE; \n").append("END;").toString();

    @Override
    public String[] getShowAliases() {
        return BOTH;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            if (ScriptUtils.eatOneWord(cmd.getSql()).trim().toUpperCase().startsWith(SHOWCONNAME.toUpperCase())) {
                return this.doConNameOrId(conn, ctx, cmd, false);
            }
            return this.doConNameOrId(conn, ctx, cmd, true);
        }
        if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            ctx.write("Not supported for nucleo connection\n");
            return true;
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doConNameOrId(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, boolean amIConId) {
        String header = "CON_NAME ";
        if (amIConId) {
            header = "CON_ID ";
        }
        try {
            String querySql = null;
            ctx.putProperty("sqldev.last.err.message.forsqlcode", null);
            String errorString = null;
            Connection currConn = ctx.getCurrentConnection();
            DBUtil dbUtil = DBUtil.getInstance(currConn);
            if (new Version(this.fetchDbVersionImpl(conn)).compareTo(new Version("12.1")) >= 0) {
                querySql = !amIConId ? "substr(SYS_CONTEXT ('USERENV', 'CON_NAME'),1,128)" : "substr(SYS_CONTEXT ('USERENV', 'CON_ID'),1,30)";
            } else {
                errorString = Messages.getString("SHOWCONVERSIONTOOLOW");
                ctx.write(errorString);
                ctx.putProperty("sqldev.last.err.message.forsqlcode", "SP2-0614: Server version too low for this feature");
                ctx.errorLog(ctx.getSourceRef(), "SP2-0614: Server version too low for this feature", cmd.getSql());
            }
            if (errorString == null) {
                String result = this.noDualUsed(conn, querySql);
                if (result != null) {
                    ctx.write(header + "\n------------------------------\n" + result + "\n");
                } else {
                    ctx.write(header + Messages.getString("SHOWPARAMETERSNORESULTSET"));
                }
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String noDualUsed(Connection conn, String oneOutBind) {
        String retVal = null;
        Statement stmt = null;
        if (conn != null && conn instanceof OracleConnection) {
            boolean amILocked = LockManager.lock(conn);
            try {
                if (amILocked) {
                    stmt = conn.prepareCall(preAmble + oneOutBind + postAmble);
                    stmt.registerOutParameter(1, 12);
                    stmt.executeUpdate();
                    retVal = stmt.getString(1);
                    if (stmt.wasNull()) {
                        retVal = null;
                    }
                }
            }
            catch (Exception e) {
                retVal = null;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        Logger.ignore(this.getClass(), e);
                    }
                }
                if (amILocked) {
                    LockManager.unlock(conn);
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchDbVersionImpl(Connection conn) throws SQLException, ThreadDeath {
        Object result = "1.0.0";
        DatabaseMetaData dmd = null;
        if (conn != null && conn instanceof OracleConnection && LockManager.lock(conn)) {
            try {
                dmd = conn.getMetaData();
                try {
                    result = dmd.getDatabaseMajorVersion() + "." + dmd.getDatabaseMinorVersion() + ".0";
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    result = "1.0.0";
                }
            }
            finally {
                LockManager.unlock(conn);
            }
        }
        return result;
    }
}

