/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class ShowConcat
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWCONCAT = new String[]{"concat", "conca", "conc", "con"};

    @Override
    public String[] getShowAliases() {
        return SHOWCONCAT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowConcat(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowConcat(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Character settingChar = ctx.getSubstitutionTerminateChar();
        if (settingChar != null) {
            String setting = String.valueOf(settingChar);
            String message = "concat \"{0}\" (hex {1})";
            ctx.write(MessageFormat.format(message, setting, String.format("%x", settingChar.charValue())) + "\n");
        } else {
            ctx.write("concat OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("concat", MessageFormat.format("\"{0}\"", ctx.getSubstitutionTerminateChar()));
    }
}

