/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.net;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.raptor.query.Bind;

public class NetCommand
extends CommandListener
implements IHelp {
    private static String LIST = "list";
    private static String DROP = "drop";
    private static String NET = "net";
    private static String SAVE = "save";
    private static String LOAD = "load";
    private static String SHOW = "show";
    private static String HELP = "help";
    public static final String ON = "ON";
    public static final String OFF = "OFF";
    public static final String WARN = "WARN";
    public static final String READONLY = "READONLY";

    @Override
    public String getCommand() {
        return "NET";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public String getDescription() {
        return CommandsHelp.getString("NET_COMMAND_DESCRIPTION");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] tokens = cmd.getSql().trim().split("[ \t\n]+");
        if (tokens.length <= 0) return false;
        String query = null;
        if (!tokens[0].toLowerCase().equals(this.getCommandName())) return false;
        if (tokens.length == 1) {
            ArrayList<String> netEntries = NetEntries.getInstance().getNetEntries();
            Iterator<String> it = netEntries.iterator();
            while (it.hasNext()) {
                ctx.write(it.next() + "\n");
            }
            return this.handleReturn(true);
        }
        if (tokens.length <= 1) {
            ctx.write("NET-002: Net add not enough arguments\n");
            return this.handleReturn(true);
        }
        Object key = "";
        if (cmd.getSql().contains("=") && !tokens[1].startsWith("=")) {
            String payload;
            String[] preEqSplit = cmd.getSql().trim().split("=")[0].split("\\s+");
            key = preEqSplit[1];
            if (preEqSplit.length > 2) {
                key = (String)key + preEqSplit[2];
            }
            if ((payload = cmd.getSql().substring(cmd.getSql().toLowerCase().indexOf("=") + 1).trim()).startsWith(":")) {
                if (payload.length() > 1) {
                    payload = payload.substring(1);
                    Bind b = ctx.getVarMap().get(payload.toUpperCase());
                    if (b != null) {
                        query = b.getValue();
                    }
                }
                if (query == null || query.equals("")) {
                    ctx.write("NET-006: No valid bind value\n");
                    return this.handleReturn(true);
                }
            } else {
                String payloadUpper = payload.toUpperCase();
                if (payload.length() > 5 && payloadUpper.startsWith("Q'") && payload.endsWith(ScriptParser.getEndQuoteString(payload.substring(2, 3)) + "'")) {
                    payload = payload.substring(3, payload.length() - 2);
                } else if (payload == null || payload.equals("")) {
                    ctx.write("NET-005: String not valid\n");
                    return this.handleReturn(true);
                }
                query = payload;
            }
            NetCommand.add(ctx, (String)ctx.getProperty("script.runner.setnetoverwrite"), (String)key, query, true);
            return this.handleReturn(true);
        }
        if (tokens[1].toLowerCase().equals(DROP)) {
            if (tokens.length != 3) return false;
            NetEntries.getInstance().drop(tokens[2]);
            return this.handleReturn(true);
        }
        if (tokens[1].toLowerCase().equals(LIST)) {
            String net = "";
            if (tokens.length > 2 && tokens[2].length() > 0) {
                net = tokens[2];
                String matchingEntry = NetEntries.getInstance().get(net);
                if (matchingEntry != null) {
                    String line = new String(new char[net.length()]).replace("\u0000", "-");
                    ctx.write(MessageFormat.format("{0}\n{1}\n", net, line));
                    ctx.write(matchingEntry + "\n");
                    return this.handleReturn(true);
                }
                ctx.write(MessageFormat.format("NET-010 - net {0} not found \n", net));
                return this.handleReturn(true);
            }
            Iterator<String> it = NetEntries.getInstance().getNetEntries().iterator();
            while (it.hasNext()) {
                ctx.write(it.next() + "\n");
            }
            return this.handleReturn(true);
        }
        if (tokens[1].toLowerCase().equals(SAVE)) {
            if (ctx.getProperty("script.runner.jline") == null) {
                ctx.write("NET-008 - save only enabled in command line mode\n");
                return this.handleReturn(true);
            }
            if (tokens.length > 2 && tokens[2] != null) {
                ctx.write(NetEntries.getInstance().save(tokens[2]));
                return this.handleReturn(true);
            }
            ctx.write(NetEntries.getInstance().save());
            return this.handleReturn(true);
        }
        if (tokens[1].toLowerCase().equals(LOAD)) {
            if (ctx.getProperty("script.runner.jline") == null) {
                ctx.write("NET-009 - load only enabled in command line mode\n");
                return this.handleReturn(true);
            }
            if (tokens.length > 2 && tokens[2] != null) {
                ctx.write(NetEntries.getInstance().load(tokens[2]));
                return this.handleReturn(true);
            }
            ctx.write(NetEntries.getInstance().load());
            return this.handleReturn(true);
        }
        if (tokens[1].toLowerCase().equals(LOAD)) {
            if (ctx.getProperty("script.runner.jline") != null) {
                NetEntries.getInstance().load();
                return this.handleReturn(true);
            }
            ctx.write("NET-009 - load only enabled in command line mode\n");
            return this.handleReturn(true);
        }
        if (tokens[1].toLowerCase().equals(HELP)) {
            ctx.write(this.getHelp());
            return false;
        }
        ctx.write("NET-001: Net command not found\n");
        return this.handleReturn(true);
    }

    public static void addOrWarn(ScriptRunnerContext src, String overWrite, String key, String query, boolean fromCommand) {
        if (overWrite == null) {
            overWrite = WARN;
        }
        String existing = NetEntries.getInstance().get(key);
        switch (overWrite) {
            case "WARN": {
                if (existing == null) break;
                if (existing == null || !query.trim().equalsIgnoreCase(existing.trim())) {
                    src.write(ScriptRunnerDbArb.format("KEY_EXISTS", "net " + key.toUpperCase() + "=" + query + ";"));
                }
                return;
            }
            case "OFF": {
                if (existing == null) break;
                return;
            }
        }
        if (existing == null || !query.trim().equalsIgnoreCase(existing.trim())) {
            NetEntries.getInstance().add(key, query);
        }
    }

    public static void add(ScriptRunnerContext src, String overWrite, String key, String query, boolean fromCommand) {
        if (key.length() < 40 && key.indexOf("=") == -1) {
            if (fromCommand) {
                NetEntries.getInstance().add(key, query);
            } else {
                NetCommand.addOrWarn(src, overWrite, key, query, fromCommand);
            }
        }
        NetEntries.getInstance().save();
    }

    public String getCommandName() {
        return NET;
    }

    boolean handleReturn(boolean b) {
        if (!b) {
            // empty if block
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

