/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ThirdPartyConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class ThirdPartyConnectorType
extends StandardFormConnectorType {
    private static final String NAME = "THIRD";
    private static final String SHORT_NAME = "T";

    protected ThirdPartyConnectorType(FlagProperty selector) {
        super(selector);
    }

    public ThirdPartyConnectorType() {
        this(ThirdPartyConnectorType.createSelectorProperty(NAME, SHORT_NAME));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        TextSecret password;
        ConnectionDetails cd;
        String user;
        super.parseConnectionSpec(args);
        String url = args.getPropertyValue(URLProperty.URL);
        if (url == null) {
            String spec = args.getConnectionSpec();
            int idx = spec.indexOf(64);
            if (idx < 0) {
                args.addError(MessageFormat.format(Messages.getString(Messages.Key.URL_UNAVAILABLE), this.getName(), spec));
            } else {
                url = spec.substring(idx + 1);
            }
        }
        if (url != null) {
            if (!SQLPLUSUtil.hasNonOracleStub(url)) {
                args.addError(MessageFormat.format(Messages.getString(Messages.Key.INVALID_PREFIX), this.getName(), url));
            } else {
                args.setPropertyValue(URLProperty.URL, url);
            }
        }
        if (ThirdPartyConnectorType.isNotEmpty(user = (cd = ThirdPartyConnectorType.createConnectDetails(args)).getConnectName())) {
            args.setPropertyValue(UserProperty.USER, user);
        }
        if (ThirdPartyConnectorType.isNotEmpty(password = cd.getConnectPassword())) {
            args.setPropertyValue(PasswordProperty.PASSWORD, password);
        }
    }

    @Override
    public ThirdPartyConnector createConnector(ConnectorArgs args) {
        return new ThirdPartyConnector(args);
    }
}

