/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.function.Consumer;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.RawPropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.SetType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;

public enum ProxyProperty implements Property<URI>
{
    PROXY;


    @Override
    public String getShortName() {
        return "P";
    }

    @Override
    public boolean matchesNull() {
        return true;
    }

    @Override
    public SetType getSetType() {
        return SetType.SETTABLE;
    }

    @Override
    public URI createValue(ScriptRunnerContext ctx, RawPropertyValues rawValues, Consumer<String> errorConsumer) {
        URI uri = null;
        Object rawValue = (String)rawValues.get(this.getName());
        if (rawValue != null && !((String)rawValue).isEmpty()) {
            if (!((String)rawValue).startsWith("http://") && !((String)rawValue).startsWith("https://")) {
                rawValue = "https://" + (String)rawValue;
            }
            try {
                uri = new URI((String)rawValue);
            }
            catch (URISyntaxException ex) {
                errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.INVALID_PROXY), rawValue));
            }
        }
        return uri;
    }
}

