/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect.save;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import oracle.dbtools.connections.ConnectionsResources;
import oracle.dbtools.core.connections.folder.Folder;
import oracle.dbtools.core.connections.folder.FolderSerializationException;
import oracle.dbtools.core.connections.storage.ConnectionReference;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.io.file.HomeFolder;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.save.FolderProxy;

class FolderSerializer {
    private static final String CONNECTION_FOLDERS = "connection_folders";
    private static final String JSON_FILE = "folders.json";
    private static final Path CONNECTION_FOLDERS_DIRECTORY = Paths.get(HomeFolder.ofSystem().path().toString(), "connection_folders");
    private static final Path CONNECTION_FOLDERS_PATH = CONNECTION_FOLDERS_DIRECTORY.resolve("folders.json");
    private final Folder rootFolder;

    private FolderSerializer(Path connectionsFolderPath) throws FolderSerializationException {
        this(FolderSerializer.load(connectionsFolderPath));
    }

    private FolderSerializer(Folder rootFolder) {
        this.rootFolder = rootFolder;
    }

    public static FolderSerializer create() {
        return new FolderSerializer(CONNECTION_FOLDERS_PATH);
    }

    private static Folder load(Path folderPath) {
        try {
            block7: {
                block6: {
                    if (!Files.exists(folderPath, new LinkOption[0])) break block6;
                    if (Files.size(folderPath) != 0L) break block7;
                }
                return Folder.builder(null).connections(ConnectionStorage.instance().listConnectionDirectories().stream().map(arg_0 -> ((ConnectionStorage)ConnectionStorage.instance()).loadConnectionReference(arg_0)).map(ConnectionReference::getConnectionIdentifier).collect(Collectors.toUnmodifiableList())).build();
            }
            if (!Files.isReadable(folderPath)) {
                throw new FolderSerializationException(ConnectionsResources.format("READ_PERMISSION_DENIED", folderPath));
            }
            return FolderSerializer.deserialize(Files.readString(folderPath));
        }
        catch (IOException e) {
            throw new FolderSerializationException((Throwable)e);
        }
    }

    public void persist(Folder rootFolder) throws FolderSerializationException {
        try {
            if (!Files.exists(CONNECTION_FOLDERS_PATH, new LinkOption[0])) {
                Files.createDirectories(CONNECTION_FOLDERS_DIRECTORY, new FileAttribute[0]);
                Files.createFile(CONNECTION_FOLDERS_PATH, new FileAttribute[0]);
            }
            if (!Files.isWritable(CONNECTION_FOLDERS_PATH)) {
                throw new FolderSerializationException(ConnectionsResources.format("WRITE_PERMISSION_DENIED", CONNECTION_FOLDERS_PATH));
            }
            Files.write(CONNECTION_FOLDERS_PATH, this.serialize(rootFolder).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FolderSerializationException((Throwable)e);
        }
    }

    public Folder getRootFolder() throws FolderSerializationException {
        return this.rootFolder;
    }

    private String serialize(Folder root) throws FolderSerializationException {
        try {
            return JSON.builder().enable(new JSON.Feature[]{JSON.Feature.PRESERVE_FIELD_ORDERING}).disable(new JSON.Feature[]{JSON.Feature.WRITE_NULL_PROPERTIES}).build().asString(FolderProxy.fromFolder(root));
        }
        catch (IOException e) {
            throw new FolderSerializationException((Throwable)e);
        }
    }

    private static Folder deserialize(String json) throws FolderSerializationException {
        try {
            return ((FolderProxy)JSON.builder().build().beanFrom(FolderProxy.class, (Object)json)).toFolder();
        }
        catch (IOException e) {
            throw new FolderSerializationException((Throwable)e);
        }
    }
}

