/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.bridge;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeParser;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeParserException;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableCreationInfo;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableDef;

public class BridgeCmd
extends CommandListener
implements IHelp {
    BridgeParser _bridgeParser = null;
    boolean _statusOK = true;

    @Override
    public String getCommand() {
        return "BRIDGE";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public String getDescription() {
        return CommandsHelp.getString("BRIDGE_DESCRIPTION");
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            this._statusOK = true;
            String str = cmd.getModifiedSQL();
            this._bridgeParser = null;
            this._bridgeParser = new BridgeParser(str);
            for (BridgeTableDef tableDef : this._bridgeParser.getTableDefs()) {
                tableDef.setDefaultConn(conn);
                tableDef.setScriptRunnerContext(ctx);
                this.saveInfo(tableDef.createTable(), ctx);
            }
        }
        catch (BridgeParserException e) {
            this.handleExceptionPrintHelp(Messages.getString("BRIDGE_COMMAND_INVALID_SYNTAX_OR_USERNAME_OR_PASSWORD"), ctx);
            this._statusOK = false;
        }
        catch (Exception e) {
            ScriptUtils.doWhenever(ctx, cmd, conn, true);
            this.handleException(e.getLocalizedMessage(), ctx);
            this._statusOK = false;
        }
    }

    private void saveInfo(BridgeTableCreationInfo info, ScriptRunnerContext ctx) {
        ctx.write("\n" + info.getReport() + "\n");
        ArrayList<BridgeTableCreationInfo> scriptResults = (ArrayList<BridgeTableCreationInfo>)ctx.getProperty("script.runner.results");
        if (scriptResults == null) {
            scriptResults = new ArrayList<BridgeTableCreationInfo>();
            ctx.putProperty("script.runner.results", scriptResults);
        }
        scriptResults.add(info);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (this._statusOK) {
            if (this._bridgeParser.getQuery() != null) {
                cmd.setSql(this._bridgeParser.getQuery());
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (this._bridgeParser != null && this._bridgeParser.getQuery() != null) {
            for (BridgeTableDef tableDef : this._bridgeParser.getTableDefs()) {
                if (tableDef._isAppend) continue;
                tableDef.drop();
            }
        }
    }

    private void handleExceptionPrintHelp(String message, ScriptRunnerContext ctx) {
        ctx.write("\n" + message + "\n");
        ctx.write(this.getHelp());
        ctx.putProperty("sqldev.error", Boolean.TRUE);
        ctx.putProperty("sqldev.error.any.in", Boolean.TRUE);
        ctx.putProperty("sqldev.last.err.message", message);
    }

    private void handleException(String message, ScriptRunnerContext ctx) {
        ctx.write("\n" + message + "\n");
        ctx.putProperty("sqldev.error", Boolean.TRUE);
        ctx.putProperty("sqldev.error.any.in", Boolean.TRUE);
        ctx.putProperty("sqldev.last.err.message", message);
    }
}

